"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ServerlessFunctions = ServerlessFunctions;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _formatters = require("../../../../../common/utils/formatters");
var _use_apm_service_context = require("../../../../context/apm_service/use_apm_service_context");
var _use_apm_params = require("../../../../hooks/use_apm_params");
var _use_fetcher = require("../../../../hooks/use_fetcher");
var _use_time_range = require("../../../../hooks/use_time_range");
var _serverless_function_name_link = require("./serverless_function_name_link");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/metrics/serverless_metrics/serverless_functions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ServerlessFunctions() {
  const {
    query: {
      environment,
      kuery,
      rangeFrom,
      rangeTo
    }
  } = (0, _use_apm_params.useApmParams)('/services/{serviceName}/metrics');
  const {
    start,
    end
  } = (0, _use_time_range.useTimeRange)({
    rangeFrom,
    rangeTo
  });
  const {
    serviceName
  } = (0, _use_apm_service_context.useApmServiceContext)();
  const {
    data = {
      serverlessFunctionsOverview: []
    },
    status
  } = (0, _use_fetcher.useFetcher)(callApmApi => {
    if (!start || !end) {
      return undefined;
    }
    return callApmApi('GET /internal/apm/services/{serviceName}/metrics/serverless/functions_overview', {
      params: {
        path: {
          serviceName
        },
        query: {
          kuery,
          environment,
          start,
          end
        }
      }
    });
  }, [kuery, environment, serviceName, start, end]);
  const columns = [{
    field: 'serverlessFunctionName',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.functionName', {
      defaultMessage: 'Function name'
    }),
    sortable: true,
    truncateText: true,
    render: (_, item) => {
      return /*#__PURE__*/_react.default.createElement(_serverless_function_name_link.ServerlessFunctionNameLink, {
        serverlessFunctionName: item.serverlessFunctionName,
        serverlessId: item.serverlessId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 65,
          columnNumber: 11
        }
      });
    }
  }, {
    field: 'serverlessDurationAvg',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.functionDuration', {
      defaultMessage: 'Function duration'
    }),
    sortable: true,
    render: (_, {
      serverlessDurationAvg
    }) => {
      return (0, _formatters.asMillisecondDuration)(serverlessDurationAvg);
    }
  }, {
    field: 'billedDurationAvg',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.billedDuration', {
      defaultMessage: 'Billed duration'
    }),
    sortable: true,
    render: (_, {
      billedDurationAvg
    }) => {
      return (0, _formatters.asMillisecondDuration)(billedDurationAvg);
    }
  }, {
    field: 'avgMemoryUsed',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.memoryUsageAvg', {
      defaultMessage: 'Memory usage avg.'
    }),
    sortable: true,
    render: (_, {
      avgMemoryUsed
    }) => {
      return (0, _formatters.asDynamicBytes)(avgMemoryUsed);
    }
  }, {
    field: 'memorySize',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.memorySize', {
      defaultMessage: 'Memory size'
    }),
    sortable: true,
    render: (_, {
      memorySize
    }) => {
      return (0, _formatters.asDynamicBytes)(memorySize);
    }
  }, {
    field: 'coldStartCount',
    name: _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.coldStart', {
      defaultMessage: 'Cold start'
    }),
    sortable: true
  }];
  const isLoading = status === _use_fetcher.FETCH_STATUS.LOADING;
  const sorting = (0, _react.useMemo)(() => ({
    sort: {
      field: 'serverlessDurationAvg',
      direction: 'desc'
    }
  }), []);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.apm.serverlessMetrics.serverlessFunctions.title', {
    defaultMessage: 'Lambda functions'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
    loading: isLoading,
    items: data.serverlessFunctionsOverview,
    columns: columns,
    pagination: {
      showPerPageOptions: false,
      pageSize: 5
    },
    sorting: sorting,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 11
    }
  }))));
}