"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactQuery = require("@kbn/react-query");
var _public = require("@kbn/core/public");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _create_call_apm_api = require("../services/rest/create_call_apm_api");
var _set_help_extension = require("../set_help_extension");
var _update_badge = require("../update_badge");
var _app_root = require("../components/routing/app_root");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/application/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * This module is rendered asynchronously in the Kibana platform.
 */
const renderApp = ({
  coreStart,
  pluginsSetup,
  appMountParameters,
  config,
  pluginsStart,
  observabilityRuleTypeRegistry,
  apmServices,
  kibanaEnvironment
}) => {
  const {
    element,
    theme$
  } = appMountParameters;
  const apmPluginContextValue = {
    appMountParameters,
    config,
    core: coreStart,
    plugins: pluginsSetup,
    data: pluginsStart.data,
    inspector: pluginsStart.inspector,
    observability: pluginsStart.observability,
    observabilityShared: pluginsStart.observabilityShared,
    observabilityRuleTypeRegistry,
    dataViews: pluginsStart.dataViews,
    unifiedSearch: pluginsStart.unifiedSearch,
    lens: pluginsStart.lens,
    uiActions: pluginsStart.uiActions,
    observabilityAIAssistant: pluginsStart.observabilityAIAssistant,
    share: pluginsSetup.share,
    kibanaEnvironment,
    licensing: pluginsStart.licensing
  };
  const queryClient = new _reactQuery.QueryClient();

  // render APM feedback link in global help menu
  (0, _set_help_extension.setHelpExtension)(coreStart);
  (0, _update_badge.setReadonlyBadge)(coreStart);
  (0, _create_call_apm_api.createCallApmApi)(coreStart);

  // add .kbnAppWrappers class to root element
  element.classList.add(_public.APP_WRAPPER_CLASS);
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, (0, _extends2.default)({}, coreStart, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$
    },
    modify: {
      breakpoint: {
        xxl: 1600,
        xxxl: 2000
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_app_root.ApmAppRoot, {
    apmPluginContextValue: apmPluginContextValue,
    pluginsStart: pluginsStart,
    apmServices: apmServices,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 11
    }
  })))), element);
  return () => {
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;