"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.denormalizeActions = denormalizeActions;
var _constants = require("../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function denormalizeActions(actionsClient, alertActions) {
  const references = [];
  const actions = [];
  if (alertActions.length) {
    const actionIds = [...new Set(alertActions.map(alertAction => alertAction.id))];
    const actionResults = await actionsClient.getBulk({
      ids: actionIds,
      throwIfSystemAction: false
    });
    const actionTypeIds = [...new Set(actionResults.map(action => action.actionTypeId))];
    actionTypeIds.forEach(id => {
      // Notify action type usage via "isActionTypeEnabled" function
      actionsClient.isActionTypeEnabled(id, {
        notifyUsage: true
      });
    });
    alertActions.forEach(({
      id,
      ...alertAction
    }, i) => {
      const actionResultValue = actionResults.find(action => action.id === id);
      if (actionResultValue) {
        if (actionsClient.isPreconfigured(id)) {
          actions.push({
            ...alertAction,
            actionRef: `${_constants.preconfiguredConnectorActionRefPrefix}${id}`,
            actionTypeId: actionResultValue.actionTypeId
          });
        } else if (actionsClient.isSystemAction(id)) {
          actions.push({
            ...alertAction,
            actionRef: `${_constants.systemConnectorActionRefPrefix}${id}`,
            actionTypeId: actionResultValue.actionTypeId
          });
        } else {
          const actionRef = `action_${i}`;
          references.push({
            id,
            name: actionRef,
            type: 'action'
          });
          actions.push({
            ...alertAction,
            actionRef,
            actionTypeId: actionResultValue.actionTypeId
          });
        }
      } else {
        actions.push({
          ...alertAction,
          actionRef: '',
          actionTypeId: ''
        });
      }
    });
  }
  return {
    actions,
    references
  };
}