"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QualityIndicator = QualityIndicator;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/dataset_quality/public/components/quality_indicator/indicator.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function QualityIndicator({
  quality,
  description,
  dataTestSubj
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const qualityColors = {
    poor: euiTheme.colors.backgroundLightDanger,
    degraded: euiTheme.colors.backgroundLightWarning,
    good: euiTheme.colors.backgroundLightSuccess
  };
  const qualityTextColors = {
    poor: euiTheme.colors.textDanger,
    degraded: euiTheme.colors.textWarning,
    good: euiTheme.colors.textSuccess
  };
  const qualityIcons = {
    poor: 'error',
    degraded: 'warning',
    good: 'checkCircle'
  };
  const BadgeIconType = () => /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    size: "s",
    type: qualityIcons[quality],
    color: qualityTextColors[quality],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
    color: qualityColors[quality],
    iconType: BadgeIconType,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    color: qualityTextColors[quality],
    size: "s",
    css: (0, _react2.css)`
          margin-left: ${euiTheme.size.xs};
        `,
    "data-test-subj": dataTestSubj,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 7
    }
  }, description));
}