"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.I18nService = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n_eui_mapping = require("./i18n_eui_mapping");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/src/core/packages/i18n/browser-internal/src/i18n_service.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
/**
 * Service that is responsible for i18n capabilities.
 * @internal
 */
class I18nService {
  /**
   * Used exclusively to give a Context component to FatalErrorsService which
   * may render before Core successfully sets up or starts.
   *
   * Separated from `start` to disambiguate that this can be called from within
   * Core outside the lifecycle flow.
   * @internal
   */
  getContext() {
    const euiContextMapping = (0, _i18n_eui_mapping.getEuiContextMapping)();
    const mapping = {
      ...euiContextMapping
    };
    return {
      Context: function I18nContext({
        children
      }) {
        return /*#__PURE__*/_react.default.createElement(_i18nReact.I18nProvider, {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 39,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_eui.EuiContext, {
          i18n: {
            mapping
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 40,
            columnNumber: 13
          }
        }, children));
      }
    };
  }
  start() {
    return this.getContext();
  }
  stop() {
    // nothing to do here currently
  }
}
exports.I18nService = I18nService;