"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.isCommonError = exports.defaultNoDataRenderer = exports.defaultLoadingRenderer = exports.PACKAGE_NOT_INSTALLED_TEST_SUBJECT = exports.LOADING_STATE_TEST_SUBJECT = exports.KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = exports.DEFAULT_NO_DATA_TEST_SUBJECT = exports.CspNoDataPage = exports.CloudPosturePage = exports.CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _react2 = require("@emotion/react");
var _full_size_centered_page = require("./full_size_centered_page");
var _csp_loading_state = require("./csp_loading_state");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/cloud_security_posture/public/components/cloud_posture_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const LOADING_STATE_TEST_SUBJECT = exports.LOADING_STATE_TEST_SUBJECT = 'cloud_posture_page_loading';
const ERROR_STATE_TEST_SUBJECT = exports.ERROR_STATE_TEST_SUBJECT = 'cloud_posture_page_error';
const PACKAGE_NOT_INSTALLED_TEST_SUBJECT = exports.PACKAGE_NOT_INSTALLED_TEST_SUBJECT = 'cloud_posture_page_package_not_installed';
const CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = exports.CSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = 'cloud_posture_page_cspm_not_installed';
const KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = exports.KSPM_INTEGRATION_NOT_INSTALLED_TEST_SUBJECT = 'cloud_posture_page_kspm_not_installed';
const DEFAULT_NO_DATA_TEST_SUBJECT = exports.DEFAULT_NO_DATA_TEST_SUBJECT = 'cloud_posture_page_no_data';
const isCommonError = error => {
  var _body, _body2, _body3;
  if (!(error !== null && error !== void 0 && error.body) || !(error !== null && error !== void 0 && (_body = error.body) !== null && _body !== void 0 && _body.error) || !(error !== null && error !== void 0 && (_body2 = error.body) !== null && _body2 !== void 0 && _body2.message) || !(error !== null && error !== void 0 && (_body3 = error.body) !== null && _body3 !== void 0 && _body3.statusCode)) {
    return false;
  }
  return true;
};
exports.isCommonError = isCommonError;
const CspNoDataPage = ({
  pageTitle,
  docsLink,
  actionHref,
  actionTitle,
  actionDescription,
  testId
}) => {
  return /*#__PURE__*/_react.default.createElement(_public.NoDataPage, {
    "data-test-subj": testId,
    css: (0, _react2.css)`
        > :nth-child(3) {
          display: block;
          margin: auto;
          width: 450px;
        }
      `,
    pageTitle: pageTitle,
    solution: _i18n.i18n.translate('xpack.csp.cloudPosturePage.packageNotInstalled.solutionNameLabel', {
      defaultMessage: 'Cloud Security Posture'
    }),
    docsLink: docsLink,
    logo: "logoSecurity",
    actions: {
      elasticAgent: {
        href: actionHref,
        isDisabled: !actionHref,
        title: actionTitle,
        description: actionDescription
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 5
    }
  });
};
exports.CspNoDataPage = CspNoDataPage;
const defaultLoadingRenderer = () => /*#__PURE__*/_react.default.createElement(_csp_loading_state.CspLoadingState, {
  "data-test-subj": LOADING_STATE_TEST_SUBJECT,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 92,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
  id: "xpack.csp.cloudPosturePage.loadingDescription",
  defaultMessage: "Loading...",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 93,
    columnNumber: 5
  }
}));
exports.defaultLoadingRenderer = defaultLoadingRenderer;
const defaultErrorRenderer = error => /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 101,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  color: "danger",
  iconType: "warning",
  "data-test-subj": ERROR_STATE_TEST_SUBJECT,
  title: /*#__PURE__*/_react.default.createElement("h2", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.cloudPosturePage.errorRenderer.errorTitle",
    defaultMessage: "We couldn't fetch your cloud security posture data",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  })),
  body: isCommonError(error) ? /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.csp.cloudPosturePage.errorRenderer.errorDescription",
    defaultMessage: "{error} {statusCode}: {body}",
    values: {
      error: error.body.error,
      statusCode: error.body.statusCode,
      body: error.body.message
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 13
    }
  })) : undefined,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 102,
    columnNumber: 5
  }
}));
const defaultNoDataRenderer = () => /*#__PURE__*/_react.default.createElement(_full_size_centered_page.FullSizeCenteredPage, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 134,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(_public.NoDataPage, {
  "data-test-subj": DEFAULT_NO_DATA_TEST_SUBJECT,
  pageTitle: _i18n.i18n.translate('xpack.csp.cloudPosturePage.defaultNoDataConfig.pageTitle', {
    defaultMessage: 'No data found'
  }),
  solution: _i18n.i18n.translate('xpack.csp.cloudPosturePage.defaultNoDataConfig.solutionNameLabel', {
    defaultMessage: 'Cloud Security Posture'
  })
  // TODO: Add real docs link once we have it
  ,
  docsLink: 'https://www.elastic.co/guide/index.html',
  logo: 'logoSecurity',
  actions: {},
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 135,
    columnNumber: 5
  }
}));
exports.defaultNoDataRenderer = defaultNoDataRenderer;
const CloudPosturePage = ({
  children,
  query,
  loadingRender = defaultLoadingRenderer,
  errorRender = defaultErrorRenderer,
  noDataRenderer = defaultNoDataRenderer
}) => {
  const render = () => {
    if (!query) {
      return children;
    }
    if (query.isError) {
      return errorRender(query.error);
    }
    if (query.isLoading) {
      return loadingRender();
    }
    if (!query.data) {
      return noDataRenderer();
    }
    return children;
  };
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, render());
};
exports.CloudPosturePage = CloudPosturePage;