"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CallOut = void 0;
var _eui = require("@elastic/eui");
var _fp = require("lodash/fp");
var _react = _interopRequireWildcard(require("react"));
var _types = require("./types");
var i18n = _interopRequireWildcard(require("./translations"));
var _use_cases_context = require("../../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/use_push_to_service/callout/callout.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CallOutComponent = ({
  handleButtonClick,
  id,
  messages,
  type,
  hasLicenseError
}) => {
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const handleCallOut = (0, _react.useCallback)(e => handleButtonClick(e, id, type), [handleButtonClick, id, type]);
  const isCaseClosed = (0, _react.useMemo)(() => messages.map(m => m.id).includes(_types.CLOSED_CASE_PUSH_ERROR_ID), [messages]);
  return !(0, _fp.isEmpty)(messages) ? /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    title: isCaseClosed ? i18n.PUSH_DISABLE_BECAUSE_CASE_CLOSED_TITLE : hasLicenseError ? i18n.PUSH_DISABLE_BY_LICENSE_TITLE : i18n.ERROR_PUSH_SERVICE_CALLOUT_TITLE,
    color: type,
    iconType: "gear",
    "data-test-subj": `case-callout-${id}`,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 49,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiDescriptionList, {
    "data-test-subj": `callout-messages-${id}`,
    listItems: messages,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }), !isCaseClosed && !hasLicenseError && permissions.settings && /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": `callout-onclick-${id}`,
    color: type === 'success' ? 'success' : type,
    onClick: handleCallOut,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 9
    }
  }, i18n.ADD_CONNECTOR)) : null;
};
CallOutComponent.displayName = 'CallOut';
const CallOut = exports.CallOut = /*#__PURE__*/(0, _react.memo)(CallOutComponent);