"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FilePreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _sharedUxFileContext = require("@kbn/shared-ux-file-context");
var _files = require("../../../common/files");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/files/file_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const getOverlayMaskCss = (0, _react2.css)`
  padding-block-end: 0vh !important;

  img {
    max-height: 85vh;
    max-width: 85vw;
    object-fit: contain;
  }
`;
const FilePreview = ({
  closePreview,
  selectedFile
}) => {
  const {
    client: filesClient
  } = (0, _sharedUxFileContext.useFilesContext)();
  const {
    owner
  } = (0, _use_cases_context.useCasesContext)();
  (0, _react.useEffect)(() => {
    const keyboardListener = event => {
      if (event.key === _eui.keys.ESCAPE || event.code === 'Escape') {
        closePreview();
      }
    };
    window.addEventListener('keyup', keyboardListener);
    return () => {
      window.removeEventListener('keyup', keyboardListener);
    };
  }, [closePreview]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiOverlayMask, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    css: getOverlayMaskCss,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFocusTrap, {
    onClickOutside: closePreview,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiImage, {
    alt: selectedFile.name,
    size: "original",
    src: filesClient.getDownloadHref({
      id: selectedFile.id,
      fileKind: (0, _files.constructFileKindIdByOwner)(owner[0])
    }),
    "data-test-subj": "cases-files-image-preview",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 11
    }
  }))));
};
exports.FilePreview = FilePreview;
FilePreview.displayName = 'FilePreview';