"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createHref = createHref;
exports.fromQuery = fromQuery;
exports.push = push;
exports.replace = replace;
exports.toQuery = toQuery;
var _queryString = require("query-string");
var _public = require("@kbn/kibana-utils-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function toQuery(search) {
  return search ? (0, _queryString.parse)(search.slice(1), {
    sort: false
  }) : {};
}
function fromQuery(query) {
  const encodedQuery = _public.url.encodeQuery(query, value => encodeURIComponent(value).replace(/%3A/g, ':'));
  return (0, _queryString.stringify)(encodedQuery, {
    sort: false,
    encode: false
  });
}
function getNextLocation(history, locationWithQuery) {
  const {
    query,
    ...rest
  } = locationWithQuery;
  return {
    ...history.location,
    ...rest,
    search: fromQuery({
      ...toQuery(history.location.search),
      ...query
    })
  };
}
function replace(history, locationWithQuery) {
  const location = getNextLocation(history, locationWithQuery);
  return history.replace(location);
}
function push(history, locationWithQuery) {
  const location = getNextLocation(history, locationWithQuery);
  return history.push(location);
}
function createHref(history, locationWithQuery) {
  const location = getNextLocation(history, locationWithQuery);
  return history.createHref(location);
}

// forces every value of T[K] to be type: string