"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlyoutTopLevelProperties = FlyoutTopLevelProperties;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _use_apm_router = require("../../../../../../hooks/use_apm_router");
var _apm = require("../../../../../../../common/es_fields/apm");
var _environment_filter_values = require("../../../../../../../common/environment_filter_values");
var _latency_aggregation_types = require("../../../../../../../common/latency_aggregation_types");
var _use_apm_params = require("../../../../../../hooks/use_apm_params");
var _transaction_detail_link = require("../../../../../shared/links/apm/transaction_detail_link");
var _service_link = require("../../../../../shared/links/apm/service_link");
var _sticky_properties = require("../../../../../shared/sticky_properties");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/flyout_top_level_properties.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function FlyoutTopLevelProperties({
  transaction
}) {
  const {
    query
  } = (0, _use_apm_params.useAnyOfApmParams)('/services/{serviceName}/transactions/view', '/mobile-services/{serviceName}/transactions/view', '/traces/explorer', '/dependencies/operation');
  const {
    link
  } = (0, _use_apm_router.useApmRouter)();
  const latencyAggregationType = 'latencyAggregationType' in query && query.latencyAggregationType || _latency_aggregation_types.LatencyAggregationType.avg;
  const serviceGroup = 'serviceGroup' in query && query.serviceGroup || '';
  if (!transaction) {
    return null;
  }
  const nextEnvironment = (0, _environment_filter_values.getNextEnvironmentUrlParam)({
    requestedEnvironment: transaction.service.environment,
    currentEnvironmentUrlParam: query.environment
  });
  const stickyProperties = [{
    label: _i18n.i18n.translate('xpack.apm.transactionDetails.serviceLabel', {
      defaultMessage: 'Service'
    }),
    fieldName: _apm.SERVICE_NAME,
    val: /*#__PURE__*/_react.default.createElement(_service_link.ServiceLink, {
      agentName: transaction.agent.name,
      query: {
        kuery: query.kuery,
        latencyAggregationType,
        offset: query.offset,
        rangeFrom: query.rangeFrom,
        rangeTo: query.rangeTo,
        comparisonEnabled: query.comparisonEnabled,
        transactionType: transaction.transaction.type,
        serviceGroup,
        environment: nextEnvironment
      },
      serviceName: transaction.service.name,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 54,
        columnNumber: 9
      }
    }),
    width: '25%'
  }, {
    label: _i18n.i18n.translate('xpack.apm.transactionDetails.transactionLabel', {
      defaultMessage: 'Transaction'
    }),
    fieldName: _apm.TRANSACTION_NAME,
    val: /*#__PURE__*/_react.default.createElement(_transaction_detail_link.TransactionDetailLink, {
      transactionName: transaction.transaction.name,
      href: link('/services/{serviceName}/transactions/view', {
        path: {
          serviceName: transaction.service.name
        },
        query: {
          ...query,
          serviceGroup,
          latencyAggregationType,
          transactionName: transaction.transaction.name
        }
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 78,
        columnNumber: 9
      }
    }, transaction.transaction.name),
    width: '25%'
  }];
  return /*#__PURE__*/_react.default.createElement(_sticky_properties.StickyProperties, {
    stickyProperties: stickyProperties,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 10
    }
  });
}