"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorSampleContextualInsight = ErrorSampleContextualInsight;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireWildcard(require("react"));
var _use_apm_plugin_context = require("../../../../context/apm_plugin/use_apm_plugin_context");
var _error_sample_detail = require("./error_sample_detail");
var _error_tabs = require("./error_tabs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/app/error_group_details/error_sampler/error_sample_contextual_insight.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ErrorSampleContextualInsight({
  error,
  transaction
}) {
  var _error$error$log, _error$error$exceptio;
  const {
    observabilityAIAssistant
  } = (0, _use_apm_plugin_context.useApmPluginContext)();
  const [logStacktrace, setLogStacktrace] = (0, _react.useState)('');
  const [exceptionStacktrace, setExceptionStacktrace] = (0, _react.useState)('');
  const messages = (0, _react.useMemo)(() => {
    var _error$service$langua, _error$service$langua2, _error$service$runtim, _error$service$runtim2, _error$service$runtim3, _error$service$runtim4, _transaction$transact;
    const serviceName = error.service.name;
    const languageName = (_error$service$langua = (_error$service$langua2 = error.service.language) === null || _error$service$langua2 === void 0 ? void 0 : _error$service$langua2.name) !== null && _error$service$langua !== void 0 ? _error$service$langua : '';
    const runtimeName = (_error$service$runtim = (_error$service$runtim2 = error.service.runtime) === null || _error$service$runtim2 === void 0 ? void 0 : _error$service$runtim2.name) !== null && _error$service$runtim !== void 0 ? _error$service$runtim : '';
    const runtimeVersion = (_error$service$runtim3 = (_error$service$runtim4 = error.service.runtime) === null || _error$service$runtim4 === void 0 ? void 0 : _error$service$runtim4.version) !== null && _error$service$runtim3 !== void 0 ? _error$service$runtim3 : '';
    const transactionName = (_transaction$transact = transaction === null || transaction === void 0 ? void 0 : transaction.transaction.name) !== null && _transaction$transact !== void 0 ? _transaction$transact : '';
    return observabilityAIAssistant === null || observabilityAIAssistant === void 0 ? void 0 : observabilityAIAssistant.getContextualInsightMessages({
      message: `I'm looking at an exception and trying to understand what it means`,
      instructions: `I'm an SRE. I am looking at an exception and trying to understand what it means.

      Your task is to describe what the error means and what it could be caused by.

      The error occurred on a service called ${serviceName}, which is a ${runtimeName} service written in ${languageName}. The
      runtime version is ${runtimeVersion}.

      The request it occurred for is called ${transactionName}.

      ${logStacktrace ? `The log stacktrace:
      ${logStacktrace}` : ''}

      ${exceptionStacktrace ? `The exception stacktrace:
      ${exceptionStacktrace}` : ''}`
    });
  }, [error, transaction, logStacktrace, exceptionStacktrace, observabilityAIAssistant]);
  return observabilityAIAssistant !== null && observabilityAIAssistant !== void 0 && observabilityAIAssistant.ObservabilityAIAssistantContextualInsight && messages ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(observabilityAIAssistant.ObservabilityAIAssistantContextualInsight, {
    messages: messages,
    title: _i18n.i18n.translate('xpack.apm.errorGroupContextualInsight.explainErrorTitle', {
      defaultMessage: "What's this error?"
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement("div", {
    ref: next => {
      var _next$innerText;
      setLogStacktrace((_next$innerText = next === null || next === void 0 ? void 0 : next.innerText) !== null && _next$innerText !== void 0 ? _next$innerText : '');
    },
    style: {
      display: 'none'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 7
    }
  }, ((_error$error$log = error.error.log) === null || _error$error$log === void 0 ? void 0 : _error$error$log.message) && /*#__PURE__*/_react.default.createElement(_error_sample_detail.ErrorSampleDetailTabContent, {
    error: error,
    currentTab: _error_tabs.logStacktraceTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    ref: next => {
      var _next$innerText2;
      setExceptionStacktrace((_next$innerText2 = next === null || next === void 0 ? void 0 : next.innerText) !== null && _next$innerText2 !== void 0 ? _next$innerText2 : '');
    },
    style: {
      display: 'none'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 7
    }
  }, ((_error$error$exceptio = error.error.exception) === null || _error$error$exceptio === void 0 ? void 0 : _error$error$exceptio.length) && /*#__PURE__*/_react.default.createElement(_error_sample_detail.ErrorSampleDetailTabContent, {
    error: error,
    currentTab: _error_tabs.exceptionStacktraceTab,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 11
    }
  }))) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}