"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformBulkEnableResponse = void 0;
var _transforms = require("../../../../transforms");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const transformBulkEnableResponse = response => {
  return {
    rules: response.rules.map(rule => (0, _transforms.transformRuleToRuleResponseV1)(rule)),
    errors: response.errors,
    total: response.total,
    task_ids_failed_to_be_enabled: response.taskIdsFailedToBeEnabled
  };
};
exports.transformBulkEnableResponse = transformBulkEnableResponse;