"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.resolveResolvedValueBindingParams = resolveResolvedValueBindingParams;
const common_1 = require("@inversifyjs/common");
function resolveResolvedValueBindingParams(resolveServiceNode) {
    return (params, node) => {
        const paramsResolvedValues = [];
        for (const param of node.params) {
            paramsResolvedValues.push(resolveServiceNode(params, param));
        }
        return paramsResolvedValues.some(common_1.isPromise)
            ? Promise.all(paramsResolvedValues)
            : paramsResolvedValues;
    };
}
//# sourceMappingURL=resolveResolvedValueBindingParams.js.map