"use strict";

function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useScrollCellIntoView = exports.useScrollBars = exports.useScroll = void 0;
var _react = _interopRequireWildcard(require("react"));
var _services = require("../../../services");
var _global_styling = require("../../../global_styling");
var _cell = require("../body/cell");
var _focus = require("./focus");
var _scrolling = require("./scrolling.styles");
var _react2 = require("@emotion/react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return e; }; var t, e = {}, r = Object.prototype, n = r.hasOwnProperty, o = Object.defineProperty || function (t, e, r) { t[e] = r.value; }, i = "function" == typeof Symbol ? Symbol : {}, a = i.iterator || "@@iterator", c = i.asyncIterator || "@@asyncIterator", u = i.toStringTag || "@@toStringTag"; function define(t, e, r) { return Object.defineProperty(t, e, { value: r, enumerable: !0, configurable: !0, writable: !0 }), t[e]; } try { define({}, ""); } catch (t) { define = function define(t, e, r) { return t[e] = r; }; } function wrap(t, e, r, n) { var i = e && e.prototype instanceof Generator ? e : Generator, a = Object.create(i.prototype), c = new Context(n || []); return o(a, "_invoke", { value: makeInvokeMethod(t, r, c) }), a; } function tryCatch(t, e, r) { try { return { type: "normal", arg: t.call(e, r) }; } catch (t) { return { type: "throw", arg: t }; } } e.wrap = wrap; var h = "suspendedStart", l = "suspendedYield", f = "executing", s = "completed", y = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var p = {}; define(p, a, function () { return this; }); var d = Object.getPrototypeOf, v = d && d(d(values([]))); v && v !== r && n.call(v, a) && (p = v); var g = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(p); function defineIteratorMethods(t) { ["next", "throw", "return"].forEach(function (e) { define(t, e, function (t) { return this._invoke(e, t); }); }); } function AsyncIterator(t, e) { function invoke(r, o, i, a) { var c = tryCatch(t[r], t, o); if ("throw" !== c.type) { var u = c.arg, h = u.value; return h && "object" == _typeof(h) && n.call(h, "__await") ? e.resolve(h.__await).then(function (t) { invoke("next", t, i, a); }, function (t) { invoke("throw", t, i, a); }) : e.resolve(h).then(function (t) { u.value = t, i(u); }, function (t) { return invoke("throw", t, i, a); }); } a(c.arg); } var r; o(this, "_invoke", { value: function value(t, n) { function callInvokeWithMethodAndArg() { return new e(function (e, r) { invoke(t, n, e, r); }); } return r = r ? r.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); } }); } function makeInvokeMethod(e, r, n) { var o = h; return function (i, a) { if (o === f) throw Error("Generator is already running"); if (o === s) { if ("throw" === i) throw a; return { value: t, done: !0 }; } for (n.method = i, n.arg = a;;) { var c = n.delegate; if (c) { var u = maybeInvokeDelegate(c, n); if (u) { if (u === y) continue; return u; } } if ("next" === n.method) n.sent = n._sent = n.arg;else if ("throw" === n.method) { if (o === h) throw o = s, n.arg; n.dispatchException(n.arg); } else "return" === n.method && n.abrupt("return", n.arg); o = f; var p = tryCatch(e, r, n); if ("normal" === p.type) { if (o = n.done ? s : l, p.arg === y) continue; return { value: p.arg, done: n.done }; } "throw" === p.type && (o = s, n.method = "throw", n.arg = p.arg); } }; } function maybeInvokeDelegate(e, r) { var n = r.method, o = e.iterator[n]; if (o === t) return r.delegate = null, "throw" === n && e.iterator.return && (r.method = "return", r.arg = t, maybeInvokeDelegate(e, r), "throw" === r.method) || "return" !== n && (r.method = "throw", r.arg = new TypeError("The iterator does not provide a '" + n + "' method")), y; var i = tryCatch(o, e.iterator, r.arg); if ("throw" === i.type) return r.method = "throw", r.arg = i.arg, r.delegate = null, y; var a = i.arg; return a ? a.done ? (r[e.resultName] = a.value, r.next = e.nextLoc, "return" !== r.method && (r.method = "next", r.arg = t), r.delegate = null, y) : a : (r.method = "throw", r.arg = new TypeError("iterator result is not an object"), r.delegate = null, y); } function pushTryEntry(t) { var e = { tryLoc: t[0] }; 1 in t && (e.catchLoc = t[1]), 2 in t && (e.finallyLoc = t[2], e.afterLoc = t[3]), this.tryEntries.push(e); } function resetTryEntry(t) { var e = t.completion || {}; e.type = "normal", delete e.arg, t.completion = e; } function Context(t) { this.tryEntries = [{ tryLoc: "root" }], t.forEach(pushTryEntry, this), this.reset(!0); } function values(e) { if (e || "" === e) { var r = e[a]; if (r) return r.call(e); if ("function" == typeof e.next) return e; if (!isNaN(e.length)) { var o = -1, i = function next() { for (; ++o < e.length;) if (n.call(e, o)) return next.value = e[o], next.done = !1, next; return next.value = t, next.done = !0, next; }; return i.next = i; } } throw new TypeError(_typeof(e) + " is not iterable"); } return GeneratorFunction.prototype = GeneratorFunctionPrototype, o(g, "constructor", { value: GeneratorFunctionPrototype, configurable: !0 }), o(GeneratorFunctionPrototype, "constructor", { value: GeneratorFunction, configurable: !0 }), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, u, "GeneratorFunction"), e.isGeneratorFunction = function (t) { var e = "function" == typeof t && t.constructor; return !!e && (e === GeneratorFunction || "GeneratorFunction" === (e.displayName || e.name)); }, e.mark = function (t) { return Object.setPrototypeOf ? Object.setPrototypeOf(t, GeneratorFunctionPrototype) : (t.__proto__ = GeneratorFunctionPrototype, define(t, u, "GeneratorFunction")), t.prototype = Object.create(g), t; }, e.awrap = function (t) { return { __await: t }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, c, function () { return this; }), e.AsyncIterator = AsyncIterator, e.async = function (t, r, n, o, i) { void 0 === i && (i = Promise); var a = new AsyncIterator(wrap(t, r, n, o), i); return e.isGeneratorFunction(r) ? a : a.next().then(function (t) { return t.done ? t.value : a.next(); }); }, defineIteratorMethods(g), define(g, u, "Generator"), define(g, a, function () { return this; }), define(g, "toString", function () { return "[object Generator]"; }), e.keys = function (t) { var e = Object(t), r = []; for (var n in e) r.push(n); return r.reverse(), function next() { for (; r.length;) { var t = r.pop(); if (t in e) return next.value = t, next.done = !1, next; } return next.done = !0, next; }; }, e.values = values, Context.prototype = { constructor: Context, reset: function reset(e) { if (this.prev = 0, this.next = 0, this.sent = this._sent = t, this.done = !1, this.delegate = null, this.method = "next", this.arg = t, this.tryEntries.forEach(resetTryEntry), !e) for (var r in this) "t" === r.charAt(0) && n.call(this, r) && !isNaN(+r.slice(1)) && (this[r] = t); }, stop: function stop() { this.done = !0; var t = this.tryEntries[0].completion; if ("throw" === t.type) throw t.arg; return this.rval; }, dispatchException: function dispatchException(e) { if (this.done) throw e; var r = this; function handle(n, o) { return a.type = "throw", a.arg = e, r.next = n, o && (r.method = "next", r.arg = t), !!o; } for (var o = this.tryEntries.length - 1; o >= 0; --o) { var i = this.tryEntries[o], a = i.completion; if ("root" === i.tryLoc) return handle("end"); if (i.tryLoc <= this.prev) { var c = n.call(i, "catchLoc"), u = n.call(i, "finallyLoc"); if (c && u) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } else if (c) { if (this.prev < i.catchLoc) return handle(i.catchLoc, !0); } else { if (!u) throw Error("try statement without catch or finally"); if (this.prev < i.finallyLoc) return handle(i.finallyLoc); } } } }, abrupt: function abrupt(t, e) { for (var r = this.tryEntries.length - 1; r >= 0; --r) { var o = this.tryEntries[r]; if (o.tryLoc <= this.prev && n.call(o, "finallyLoc") && this.prev < o.finallyLoc) { var i = o; break; } } i && ("break" === t || "continue" === t) && i.tryLoc <= e && e <= i.finallyLoc && (i = null); var a = i ? i.completion : {}; return a.type = t, a.arg = e, i ? (this.method = "next", this.next = i.finallyLoc, y) : this.complete(a); }, complete: function complete(t, e) { if ("throw" === t.type) throw t.arg; return "break" === t.type || "continue" === t.type ? this.next = t.arg : "return" === t.type ? (this.rval = this.arg = t.arg, this.method = "return", this.next = "end") : "normal" === t.type && e && (this.next = e), y; }, finish: function finish(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.finallyLoc === t) return this.complete(r.completion, r.afterLoc), resetTryEntry(r), y; } }, catch: function _catch(t) { for (var e = this.tryEntries.length - 1; e >= 0; --e) { var r = this.tryEntries[e]; if (r.tryLoc === t) { var n = r.completion; if ("throw" === n.type) { var o = n.arg; resetTryEntry(r); } return o; } } throw Error("illegal catch attempt"); }, delegateYield: function delegateYield(e, r, n) { return this.delegate = { iterator: values(e), resultName: r, nextLoc: n }, "next" === this.method && (this.arg = t), y; } }, e; }
function asyncGeneratorStep(n, t, e, r, o, a, c) { try { var i = n[a](c), u = i.value; } catch (n) { return void e(n); } i.done ? t(u) : Promise.resolve(u).then(r, o); }
function _asyncToGenerator(n) { return function () { var t = this, e = arguments; return new Promise(function (r, o) { var a = n.apply(t, e); function _next(n) { asyncGeneratorStep(a, r, o, _next, _throw, "next", n); } function _throw(n) { asyncGeneratorStep(a, r, o, _next, _throw, "throw", n); } _next(void 0); }); }; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
var ACTIONS_MENU_HEIGHT = 21;
/**
 * The primary goal of this scroll logic is to ensure keyboard navigation works accessibly,
 * but there are other scenarios where it applies (e.g. clicking partially-visible cells)
 * or is useful for (e.g. manually scrolling to cell that is currently out of viewport
 * while accounting for headers/footers/scrollbars)
 */
var useScroll = exports.useScroll = function useScroll(args) {
  var _useScrollCellIntoVie = useScrollCellIntoView(args),
    scrollCellIntoView = _useScrollCellIntoVie.scrollCellIntoView;
  var _useContext = (0, _react.useContext)(_focus.DataGridFocusContext),
    focusedCell = _useContext.focusedCell;
  (0, _react.useEffect)(function () {
    if (focusedCell) {
      scrollCellIntoView({
        rowIndex: focusedCell[1],
        colIndex: focusedCell[0]
      });
    }
  }, [focusedCell, scrollCellIntoView]);
  var _useContext2 = (0, _react.useContext)(_cell.DataGridCellPopoverContext),
    popoverIsOpen = _useContext2.popoverIsOpen,
    cellLocation = _useContext2.cellLocation;
  (0, _react.useEffect)(function () {
    if (popoverIsOpen) {
      scrollCellIntoView({
        rowIndex: cellLocation.rowIndex,
        colIndex: cellLocation.colIndex
      });
    }
  }, [popoverIsOpen, cellLocation, scrollCellIntoView]);
  return {
    scrollCellIntoView: scrollCellIntoView
  };
};

/**
 * Ensures that the passed cell is always fully in view by using cell position
 * checks and scroll adjustments/workarounds.
 */
var useScrollCellIntoView = exports.useScrollCellIntoView = function useScrollCellIntoView(_ref) {
  var gridRef = _ref.gridRef,
    outerGridRef = _ref.outerGridRef,
    hasGridScrolling = _ref.hasGridScrolling,
    headerRowHeight = _ref.headerRowHeight,
    footerRowHeight = _ref.footerRowHeight,
    visibleRowCount = _ref.visibleRowCount,
    hasStickyFooter = _ref.hasStickyFooter,
    canDragAndDropColumns = _ref.canDragAndDropColumns;
  var scrollCellIntoView = (0, _react.useCallback)(
  /*#__PURE__*/
  // Note: in order for this UX to work correctly with react-window's APIs,
  // the `rowIndex` arg expected is actually our internal `visibleRowIndex`,
  // not the `rowIndex` from the raw unsorted/unpaginated user data
  function () {
    var _ref3 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee(_ref2) {
      var _adjustedScrollLeft;
      var rowIndex, colIndex, getCell, cell, cellIsInView, isStickyHeader, isStickyFooter, isDraggableHeader, isDraggableHeaderCell, _outerGridRef$current, scrollTop, scrollLeft, adjustedScrollTop, adjustedScrollLeft, cellLeftPos, cellRightPos, rightScrollBound, rightWidthOutOfView, leftScrollBound, leftWidthOutOfView, _adjustedScrollTop, parentRow, cellBottomPos, bottomScrollBound, bottomHeightOutOfView, cellTopPos, topScrollBound, topHeightOutOfView, _adjustedScrollLeft2, _adjustedScrollTop2;
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) switch (_context.prev = _context.next) {
          case 0:
            rowIndex = _ref2.rowIndex, colIndex = _ref2.colIndex;
            if (!(!gridRef.current || !outerGridRef.current)) {
              _context.next = 3;
              break;
            }
            return _context.abrupt("return");
          case 3:
            if (hasGridScrolling) {
              _context.next = 5;
              break;
            }
            return _context.abrupt("return");
          case 5:
            // Obtain the outermost wrapper of the current cell in view in order to
            // get scroll position/height/width calculations and determine what level
            // of scroll adjustment the cell needs
            getCell = function getCell() {
              return outerGridRef.current.querySelector("[data-gridcell-column-index=\"".concat(colIndex, "\"][data-gridcell-visible-row-index=\"").concat(rowIndex, "\"]"));
            };
            cell = getCell(); // If the cell is completely out of view, we need to use react-window's
            // scrollToItem API to get it virtualized and rendered.
            cellIsInView = !!getCell();
            if (cellIsInView) {
              _context.next = 13;
              break;
            }
            gridRef.current.scrollToItem({
              rowIndex: rowIndex,
              columnIndex: colIndex
            });
            _context.next = 12;
            return new Promise(requestAnimationFrame);
          case 12:
            // The cell does not immediately render - we need to wait an async tick
            cell = getCell();
          case 13:
            if (cell) {
              _context.next = 15;
              break;
            }
            return _context.abrupt("return");
          case 15:
            // If for some reason we can't find a valid cell, short-circuit
            isStickyHeader = rowIndex === -1;
            isStickyFooter = hasStickyFooter && rowIndex === visibleRowCount;
            isDraggableHeader = canDragAndDropColumns && isStickyHeader;
            isDraggableHeaderCell = isDraggableHeader && cell.offsetLeft === 0 && colIndex !== 0; // We now manually adjust scroll positioning around the cell to ensure it's
            // fully in view on all sides. A couple of notes on this:
            // 1. We're avoiding relying on react-window's scrollToItem for this because it also
            //    does not account for sticky items (see https://github.com/bvaughn/react-window/issues/586)
            // 2. The current scroll position we're using as a base comes from either by
            //    `scrollToItem` or native .focus()'s automatic scroll behavior. This gets us
            //    halfway there, but doesn't guarantee the *full* cell in view, or account for
            //    sticky positioned rows or OS scrollbars, hence these workarounds
            _outerGridRef$current = outerGridRef.current, scrollTop = _outerGridRef$current.scrollTop, scrollLeft = _outerGridRef$current.scrollLeft;
            // Draggable header columns are nested within EuiDraggables,
            // and their offsetLeft needs to go up a wrapper as a result
            cellLeftPos = isDraggableHeaderCell ? cell.offsetParent.offsetLeft : cell.offsetLeft; // Check if the cell's right side is outside the current scrolling bounds
            cellRightPos = cellLeftPos + cell.offsetWidth;
            rightScrollBound = scrollLeft + outerGridRef.current.clientWidth; // Note: We specifically want clientWidth and not offsetWidth here to account for scrollbars
            rightWidthOutOfView = cellRightPos - rightScrollBound;
            if (rightWidthOutOfView > 0) {
              adjustedScrollLeft = scrollLeft + rightWidthOutOfView;
            }

            // Check if the cell's left side is outside the current scrolling bounds
            leftScrollBound = (_adjustedScrollLeft = adjustedScrollLeft) !== null && _adjustedScrollLeft !== void 0 ? _adjustedScrollLeft : scrollLeft;
            leftWidthOutOfView = leftScrollBound - cellLeftPos;
            if (leftWidthOutOfView > 0) {
              // Note: This overrides the right side being out of bounds, as we want to prefer
              // showing the top-left corner of items if a cell is larger than the grid container
              adjustedScrollLeft = cellLeftPos;
            }

            // Skip top/bottom scroll adjustments for sticky headers & footers
            // since they should always be in view vertically
            if (!isStickyHeader && !isStickyFooter) {
              parentRow = cell.parentNode; // Check if the cell's bottom side is outside the current scrolling bounds
              cellBottomPos = parentRow.offsetTop + cell.offsetHeight;
              bottomScrollBound = scrollTop + outerGridRef.current.clientHeight; // Note: We specifically want clientHeight and not offsetHeight here to account for scrollbars
              if (hasStickyFooter) bottomScrollBound -= footerRowHeight; // Sticky footer is not always present
              bottomHeightOutOfView = cellBottomPos - bottomScrollBound;
              if (bottomHeightOutOfView > 0) {
                adjustedScrollTop = scrollTop + bottomHeightOutOfView;
              }

              // Check if the cell's top side is outside the current scrolling bounds
              cellTopPos = parentRow.offsetTop;
              topScrollBound = (_adjustedScrollTop = adjustedScrollTop) !== null && _adjustedScrollTop !== void 0 ? _adjustedScrollTop : scrollTop + headerRowHeight; // Sticky header is always present
              topHeightOutOfView = topScrollBound - cellTopPos;
              if (topHeightOutOfView > 0) {
                // Note: This overrides the bottom side being out of bounds, as we want to prefer
                // showing the top-left corner of items if a cell is larger than the grid container
                // Additionally, add an offset for the actions menu
                adjustedScrollTop = cellTopPos - headerRowHeight - ACTIONS_MENU_HEIGHT;
              }
            }

            // Check for undefined specifically (because 0 is a valid scroll position)
            // to avoid unnecessarily calling scrollTo or hijacking scroll
            if (adjustedScrollTop !== undefined || adjustedScrollLeft !== undefined) {
              gridRef.current.scrollTo({
                scrollLeft: (_adjustedScrollLeft2 = adjustedScrollLeft) !== null && _adjustedScrollLeft2 !== void 0 ? _adjustedScrollLeft2 : scrollLeft,
                scrollTop: (_adjustedScrollTop2 = adjustedScrollTop) !== null && _adjustedScrollTop2 !== void 0 ? _adjustedScrollTop2 : scrollTop
              });
            }
          case 30:
          case "end":
            return _context.stop();
        }
      }, _callee);
    }));
    return function (_x) {
      return _ref3.apply(this, arguments);
    };
  }(), [gridRef, outerGridRef, hasGridScrolling, headerRowHeight, footerRowHeight, visibleRowCount, hasStickyFooter, canDragAndDropColumns]);
  return {
    scrollCellIntoView: scrollCellIntoView
  };
};

/**
 * Checks whether the current grid scrolls and/or has scrollbars
 */
var useScrollBars = exports.useScrollBars = function useScrollBars(outerGridRef) {
  var borderStyle = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'all';
  // https://stackoverflow.com/a/40568748/4294462
  var scrollBarHeight = outerGridRef.current ? outerGridRef.current.offsetHeight - outerGridRef.current.clientHeight : 0;
  var scrollBarWidth = outerGridRef.current ? outerGridRef.current.offsetWidth - outerGridRef.current.clientWidth : 0;

  // https://stackoverflow.com/a/5038256
  // Note that it is possible (MacOS) for a grid to scroll but not have scrollbar widths/heights
  var hasHorizontalScroll = outerGridRef.current ? outerGridRef.current.scrollWidth > outerGridRef.current.clientWidth : false;
  var hasVerticalScroll = outerGridRef.current ? outerGridRef.current.scrollHeight > outerGridRef.current.clientHeight : false;

  // If the grid scrolls or has scrollbars, we add custom border overlays
  // (since borders are normally set by cells) to ensure our grid body has
  // ending borders regardless of scroll position
  var styles = (0, _services.useEuiMemoizedStyles)(_scrolling.euiDataGridScrollBarStyles);
  var scrollBorderOverlay = (0, _react.useMemo)(function () {
    if (!hasHorizontalScroll && !hasVerticalScroll) {
      return null; // Nothing to render if the grid doesn't scroll
    }
    if (borderStyle === 'none') {
      return null; // Nothing to render if the grid doesn't use borders
    }
    return (0, _react2.jsx)("div", {
      css: styles.euiDataGrid__scrollOverlay,
      className: "euiDataGrid__scrollOverlay",
      role: "presentation"
    }, scrollBarHeight > 0 && (0, _react2.jsx)("div", {
      css: styles.euiDataGrid__scrollBarOverlayBottom,
      className: "euiDataGrid__scrollBarOverlayBottom",
      style: (0, _global_styling.logicalStyles)({
        bottom: scrollBarHeight
      })
    }), scrollBarWidth > 0 && (0, _react2.jsx)("div", {
      css: styles.euiDataGrid__scrollBarOverlayRight,
      className: "euiDataGrid__scrollBarOverlayRight",
      style: (0, _global_styling.logicalStyles)({
        top: 0,
        bottom: scrollBarHeight,
        right: scrollBarWidth
      })
    }));
  }, [hasHorizontalScroll, hasVerticalScroll, scrollBarHeight, scrollBarWidth, borderStyle, styles]);
  return {
    scrollBarHeight: scrollBarHeight,
    scrollBarWidth: scrollBarWidth,
    hasVerticalScroll: hasVerticalScroll,
    hasHorizontalScroll: hasHorizontalScroll,
    scrollBorderOverlay: scrollBorderOverlay
  };
};