"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OverallUploadStatus = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _fileUpload = require("@kbn/file-upload");
var _file_status = require("./file_status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/data_visualizer/public/application/file_data_visualizer/new/overall_upload_status.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const OverallUploadStatus = () => {
  const {
    filesStatus,
    uploadStatus,
    existingIndexName,
    indexName
  } = (0, _fileUpload.useFileUploadContext)();
  const generateStatus = statuses => {
    if (statuses.includes(_fileUpload.STATUS.STARTED)) {
      return 'current';
    } else if (statuses.includes(_fileUpload.STATUS.FAILED)) {
      return 'danger';
    } else if (statuses.every(status => status === _fileUpload.STATUS.COMPLETED)) {
      return 'complete';
    } else {
      return 'incomplete';
    }
  };
  const css = {
    '.euiStep__content': {
      paddingBlockEnd: '0px'
    }
  };
  const steps = [...(uploadStatus.modelDeployed === _fileUpload.STATUS.NA ? [] : [{
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.deployingModel', {
      defaultMessage: 'Deploying model'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.modelDeployed])
  }]), ...(existingIndexName === null ? [{
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.creatingIndexAndIngestPipeline', {
      defaultMessage: 'Creating index { indexName }',
      values: {
        indexName
      }
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.indexCreated, uploadStatus.pipelineCreated])
  }, {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.indexSearchable', {
      defaultMessage: 'Index searchable'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.indexSearchable ? _fileUpload.STATUS.COMPLETED : _fileUpload.STATUS.NOT_STARTED])
  }] : []), {
    title: existingIndexName ? _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.uploadingFilesExistingIndex', {
      defaultMessage: 'Uploading files to { existingIndexName }',
      values: {
        existingIndexName
      }
    }) : _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.uploadingFiles', {
      defaultMessage: 'Uploading files'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, filesStatus.map((status, i) => /*#__PURE__*/_react.default.createElement(_file_status.FileStatus, {
      key: i,
      index: i,
      lite: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    })),
    status: generateStatus([uploadStatus.fileImport])
  }, ...(uploadStatus.dataViewCreated === _fileUpload.STATUS.NA ? [] : [{
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.creatingDataView', {
      defaultMessage: 'Creating data view'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.dataViewCreated])
  }]), {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.uploadComplete', {
      defaultMessage: 'Upload complete'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: uploadStatus.overallImportStatus === _fileUpload.STATUS.COMPLETED ? 'complete' : 'incomplete'
  }, {
    title: _i18n.i18n.translate('xpack.dataVisualizer.file.overallUploadStatus.allDocsSearchable', {
      defaultMessage: 'All docs searchable'
    }),
    children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null),
    status: generateStatus([uploadStatus.allDocsSearchable ? _fileUpload.STATUS.COMPLETED : _fileUpload.STATUS.NOT_STARTED])
  }];
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: steps,
    titleSize: "xxs",
    css: css,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 10
    }
  });
};
exports.OverallUploadStatus = OverallUploadStatus;