"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getLeaveAction = getLeaveAction;
exports.isConfirmAction = isConfirmAction;
var _coreApplicationBrowser = require("@kbn/core-application-browser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const appLeaveActionFactory = {
  confirm(text, title, callback, confirmButtonText, buttonColor) {
    return {
      type: _coreApplicationBrowser.AppLeaveActionType.confirm,
      text,
      title,
      confirmButtonText,
      buttonColor,
      callback
    };
  },
  default() {
    return {
      type: _coreApplicationBrowser.AppLeaveActionType.default
    };
  }
};
function isConfirmAction(action) {
  return action.type === _coreApplicationBrowser.AppLeaveActionType.confirm;
}
function getLeaveAction(handler, nextAppId) {
  if (!handler) {
    return appLeaveActionFactory.default();
  }
  return handler(appLeaveActionFactory, nextAppId);
}