"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  TEMPLATE_TITLE: true,
  TEMPLATE_DESCRIPTION: true,
  NO_TEMPLATES: true,
  ADD_TEMPLATE: true,
  CREATE_TEMPLATE: true,
  REQUIRED: true,
  REQUIRED_FIELD: true,
  TEMPLATE_NAME: true,
  TEMPLATE_TAGS_HELP: true,
  TEMPLATE_FIELDS: true,
  CASE_FIELDS: true,
  CASE_SETTINGS: true,
  CONNECTOR_FIELDS: true,
  DELETE_TITLE: true,
  DELETE_MESSAGE: true,
  MAX_TEMPLATE_LIMIT: true
};
exports.TEMPLATE_TITLE = exports.TEMPLATE_TAGS_HELP = exports.TEMPLATE_NAME = exports.TEMPLATE_FIELDS = exports.TEMPLATE_DESCRIPTION = exports.REQUIRED_FIELD = exports.REQUIRED = exports.NO_TEMPLATES = exports.MAX_TEMPLATE_LIMIT = exports.DELETE_TITLE = exports.DELETE_MESSAGE = exports.CREATE_TEMPLATE = exports.CONNECTOR_FIELDS = exports.CASE_SETTINGS = exports.CASE_FIELDS = exports.ADD_TEMPLATE = void 0;
var _i18n = require("@kbn/i18n");
var _translations = require("../../common/translations");
Object.keys(_translations).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _translations[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _translations[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TEMPLATE_TITLE = exports.TEMPLATE_TITLE = _i18n.i18n.translate('xpack.cases.templates.title', {
  defaultMessage: 'Templates'
});
const TEMPLATE_DESCRIPTION = exports.TEMPLATE_DESCRIPTION = _i18n.i18n.translate('xpack.cases.templates.description', {
  defaultMessage: 'Create templates that automatically populate values in new cases.'
});
const NO_TEMPLATES = exports.NO_TEMPLATES = _i18n.i18n.translate('xpack.cases.templates.noTemplates', {
  defaultMessage: 'You do not have any templates yet'
});
const ADD_TEMPLATE = exports.ADD_TEMPLATE = _i18n.i18n.translate('xpack.cases.templates.addTemplate', {
  defaultMessage: 'Add template'
});
const CREATE_TEMPLATE = exports.CREATE_TEMPLATE = _i18n.i18n.translate('xpack.cases.templates.createTemplate', {
  defaultMessage: 'Create template'
});
const REQUIRED = exports.REQUIRED = _i18n.i18n.translate('xpack.cases.templates.required', {
  defaultMessage: 'Required'
});
const REQUIRED_FIELD = fieldName => _i18n.i18n.translate('xpack.cases.templates.requiredField', {
  values: {
    fieldName
  },
  defaultMessage: '{fieldName} is required.'
});
exports.REQUIRED_FIELD = REQUIRED_FIELD;
const TEMPLATE_NAME = exports.TEMPLATE_NAME = _i18n.i18n.translate('xpack.cases.templates.templateName', {
  defaultMessage: 'Template name'
});
const TEMPLATE_TAGS_HELP = exports.TEMPLATE_TAGS_HELP = _i18n.i18n.translate('xpack.cases.templates.templateTagsHelp', {
  defaultMessage: 'Separate tags with a line break.'
});
const TEMPLATE_FIELDS = exports.TEMPLATE_FIELDS = _i18n.i18n.translate('xpack.cases.templates.templateFields', {
  defaultMessage: 'Template fields'
});
const CASE_FIELDS = exports.CASE_FIELDS = _i18n.i18n.translate('xpack.cases.templates.caseFields', {
  defaultMessage: 'Case fields'
});
const CASE_SETTINGS = exports.CASE_SETTINGS = _i18n.i18n.translate('xpack.cases.templates.caseSettings', {
  defaultMessage: 'Case settings'
});
const CONNECTOR_FIELDS = exports.CONNECTOR_FIELDS = _i18n.i18n.translate('xpack.cases.templates.connectorFields', {
  defaultMessage: 'External Connector Fields'
});
const DELETE_TITLE = name => _i18n.i18n.translate('xpack.cases.configuration.deleteTitle', {
  values: {
    name
  },
  defaultMessage: 'Delete {name}?'
});
exports.DELETE_TITLE = DELETE_TITLE;
const DELETE_MESSAGE = name => _i18n.i18n.translate('xpack.cases.configuration.deleteMessage', {
  values: {
    name
  },
  defaultMessage: 'This action will permanently delete {name}.'
});
exports.DELETE_MESSAGE = DELETE_MESSAGE;
const MAX_TEMPLATE_LIMIT = maxTemplates => _i18n.i18n.translate('xpack.cases.templates.maxTemplateLimit', {
  values: {
    maxTemplates
  },
  defaultMessage: 'Maximum number of {maxTemplates} templates reached.'
});
exports.MAX_TEMPLATE_LIMIT = MAX_TEMPLATE_LIMIT;