"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExperimentalBadge = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _translations = require("../../common/translations");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/experimental_badge/experimental_badge.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ExperimentalBadgeComponent = ({
  icon = false,
  size = 's',
  compact = false,
  'data-test-subj': testSubj = 'case-experimental-badge'
}) => {
  const props = {
    label: compact ? null : _translations.EXPERIMENTAL_LABEL,
    size,
    ...((icon || compact) && {
      iconType: 'beaker'
    }),
    tooltipContent: _translations.EXPERIMENTAL_DESC,
    tooltipPosition: 'bottom',
    'data-test-subj': testSubj
  };
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, (0, _extends2.default)({
    css: (0, _react2.css)`
        margin-left: ${euiTheme.size.xs};
      `
  }, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 5
    }
  }));
};
ExperimentalBadgeComponent.displayName = 'ExperimentalBadge';
const ExperimentalBadge = exports.ExperimentalBadge = /*#__PURE__*/_react.default.memo(ExperimentalBadgeComponent);