"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Connectors = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _connectors_dropdown = require("./connectors_dropdown");
var i18n = _interopRequireWildcard(require("./translations"));
var _mapping = require("./mapping");
var _domain = require("../../../common/types/domain");
var _deprecated_callout = require("../connectors/deprecated_callout");
var _utils = require("../utils");
var _kibana = require("../../common/lib/kibana");
var _use_cases_context = require("../cases_context/use_cases_context");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/cases/public/components/configure_cases/connectors.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConnectorsComponent = ({
  actionTypes,
  connectors,
  disabled,
  handleShowEditFlyout,
  isLoading,
  mappings,
  onChangeConnector,
  selectedConnector,
  updateConnectorDisabled,
  onAddNewConnector
}) => {
  var _connector$name;
  const {
    actions
  } = (0, _kibana.useApplicationCapabilities)();
  const canSave = actions.crud;
  const connector = (0, _react.useMemo)(() => connectors.find(c => c.id === selectedConnector.id), [connectors, selectedConnector.id]);
  const {
    permissions
  } = (0, _use_cases_context.useCasesContext)();
  const canUseConnectors = permissions.connectors && actions.read;
  const connectorsName = (_connector$name = connector === null || connector === void 0 ? void 0 : connector.name) !== null && _connector$name !== void 0 ? _connector$name : 'none';
  const actionTypeName = (0, _react.useMemo)(() => {
    var _actionTypes$find$nam, _actionTypes$find;
    return (_actionTypes$find$nam = (_actionTypes$find = actionTypes.find(c => c.id === selectedConnector.type)) === null || _actionTypes$find === void 0 ? void 0 : _actionTypes$find.name) !== null && _actionTypes$find$nam !== void 0 ? _actionTypes$find$nam : i18n.UNKNOWN;
  }, [actionTypes, selectedConnector.type]);
  const dropDownLabel = (0, _react.useMemo)(() => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 9
    }
  }, i18n.INCIDENT_MANAGEMENT_SYSTEM_LABEL), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 9
    }
  }, connectorsName !== 'none' && /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    disabled: updateConnectorDisabled,
    onClick: handleShowEditFlyout,
    "data-test-subj": "case-configure-update-selected-connector-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 13
    }
  }, i18n.UPDATE_SELECTED_CONNECTOR(connectorsName)))), [connectorsName, handleShowEditFlyout, updateConnectorDisabled]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h2", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 95,
        columnNumber: 16
      }
    }, i18n.INCIDENT_MANAGEMENT_SYSTEM_TITLE),
    description: i18n.INCIDENT_MANAGEMENT_SYSTEM_DESC,
    "data-test-subj": "case-connectors-form-group",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    label: dropDownLabel,
    "data-test-subj": "case-connectors-form-row",
    labelAppend: canSave ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      "data-test-subj": "add-new-connector",
      onClick: onAddNewConnector,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, i18n.ADD_CONNECTOR) : null,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }, canUseConnectors ? /*#__PURE__*/_react.default.createElement(_connectors_dropdown.ConnectorsDropdown, {
    connectors: connectors,
    disabled: disabled,
    selectedConnector: selectedConnector.id,
    isLoading: isLoading,
    onChange: onChangeConnector,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 13
    }
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": "configure-case-connector-permissions-error-msg",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 15
    }
  }, i18n.READ_ACTIONS_PERMISSIONS_ERROR_MSG))), selectedConnector.type !== _domain.ConnectorTypes.none && (0, _utils.isDeprecatedConnector)(connector) && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 131,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_deprecated_callout.DeprecatedCallout, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 13
    }
  })), selectedConnector.type !== _domain.ConnectorTypes.none && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_mapping.Mapping, {
    actionTypeName: actionTypeName,
    connectorType: selectedConnector.type,
    isLoading: isLoading,
    mappings: mappings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }))));
};
ConnectorsComponent.displayName = 'Connectors';
const Connectors = exports.Connectors = /*#__PURE__*/_react.default.memo(ConnectorsComponent);