"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.WorkpadCreate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/home/workpad_create.component.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const WorkpadCreate = ({
  canUserWrite,
  disabled,
  ...rest
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, (0, _extends2.default)({}, rest, {
    iconType: "plusInCircleFilled",
    fill: true,
    disabled: !canUserWrite && !disabled,
    "data-test-subj": "create-workpad-button",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 20,
      columnNumber: 5
    }
  }), strings.getWorkpadCreateButtonLabel());
};
exports.WorkpadCreate = WorkpadCreate;
const strings = {
  getWorkpadCreateButtonLabel: () => _i18n.i18n.translate('xpack.canvas.workpadCreate.createButtonLabel', {
    defaultMessage: 'Create workpad'
  })
};