"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtendedTemplate = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _objectPathImmutable = require("object-path-immutable");
var _lodash = require("lodash");
var _ui = require("../../../../i18n/ui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/arguments/axis_config/extended_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  AxisConfig: strings
} = _ui.ArgumentStrings;
const defaultExpression = {
  type: 'expression',
  chain: [{
    type: 'function',
    function: 'axisConfig',
    arguments: {}
  }]
};
class ExtendedTemplate extends _react.PureComponent {
  constructor(...args) {
    super(...args);
    // TODO: this should be in a helper, it's the same code from container_style
    (0, _defineProperty2.default)(this, "getArgValue", (name, alt) => {
      return (0, _lodash.get)(this.props.argValue, `chain.0.arguments.${name}.0`, alt);
    });
    // TODO: this should be in a helper, it's the same code from container_style
    (0, _defineProperty2.default)(this, "setArgValue", name => ev => {
      if (!ev || !ev.target) {
        return;
      }
      const val = ev.target.value;
      const {
        argValue,
        onValueChange
      } = this.props;
      const oldVal = typeof argValue === 'boolean' ? defaultExpression : argValue;
      const newValue = (0, _objectPathImmutable.set)(oldVal, `chain.0.arguments.${name}.0`, val);
      onValueChange(newValue);
    });
  }
  render() {
    const isDisabled = typeof this.props.argValue === 'boolean' && this.props.argValue === false;
    if (isDisabled) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        color: "subdued",
        size: "xs",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 75,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 76,
          columnNumber: 11
        }
      }, strings.getDisabledText()));
    }
    const positions = {
      xaxis: [{
        value: 'bottom',
        text: strings.getPositionBottom()
      }, {
        value: 'top',
        text: strings.getPositionTop()
      }],
      yaxis: [{
        value: 'left',
        text: strings.getPositionLeft()
      }, {
        value: 'right',
        text: strings.getPositionRight()
      }]
    };
    const argName = this.props.typeInstance.name;
    const position = this.getArgValue('position', positions[argName][0].value);
    const options = positions[argName];
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: strings.getPositionLabel(),
      display: "columnCompressed",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      compressed: true,
      value: position,
      options: options,
      onChange: this.setArgValue('position'),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 99,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 9
      }
    }));
  }
}
exports.ExtendedTemplate = ExtendedTemplate;
(0, _defineProperty2.default)(ExtendedTemplate, "propTypes", {
  onValueChange: _propTypes.default.func.isRequired,
  argValue: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.shape({
    chain: _propTypes.default.array
  }).isRequired]),
  typeInstance: _propTypes.default.object.isRequired
});
(0, _defineProperty2.default)(ExtendedTemplate, "displayName", 'AxisConfigExtendedInput');