"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TreemapChart = TreemapChart;
var _react = _interopRequireDefault(require("react"));
var _charts = require("@elastic/charts");
var _chartsTheme = require("@kbn/charts-theme");
var _eui = require("@elastic/eui");
var _config = require("@elastic/charts/dist/chart_types/partition_chart/layout/config");
var _lodash = require("lodash");
var _chart_container = require("../chart_container");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/treemap_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TreemapChart({
  data,
  height,
  fetchStatus,
  id
}) {
  const colorPalette = (0, _eui.euiPaletteColorBlind)();
  const chartBaseTheme = (0, _chartsTheme.useElasticChartsTheme)();
  return /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: !(0, _lodash.isEmpty)(data),
    height: height,
    status: fetchStatus,
    id: id,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: chartBaseTheme,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Partition, {
    data: data,
    id: "spec_1",
    valueAccessor: d => d.count,
    valueGetter: _config.percentValueGetter,
    layout: _charts.PartitionLayout.treemap,
    layers: [{
      groupByRollup: d => d.label,
      shape: {
        fillColor: (dataName, sortIndex) => colorPalette[Math.floor(sortIndex % 10)]
      },
      fillLabel: {
        valueFormatter: () => '',
        fontWeight: 500,
        minFontSize: 10,
        maxFontSize: 14
      },
      nodeLabel: label => label
    }],
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 9
    }
  })));
}