"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.InstancesLatencyDistributionChart = InstancesLatencyDistributionChart;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _reactRouterDom = require("react-router-dom");
var _public = require("@kbn/observability-shared-plugin/public");
var _use_previous_period_text = require("../../../../hooks/use_previous_period_text");
var _apm = require("../../../../../common/es_fields/apm");
var _formatters = require("../../../../../common/utils/formatters");
var urlHelpers = _interopRequireWildcard(require("../../links/url_helpers"));
var _chart_container = require("../chart_container");
var _helper = require("../transaction_charts/helper");
var _custom_tooltip = require("./custom_tooltip");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/instances_latency_distribution_chart/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function InstancesLatencyDistributionChart({
  height,
  items = [],
  status,
  comparisonItems = []
}) {
  const history = (0, _reactRouterDom.useHistory)();
  const hasData = items.length > 0;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const chartThemes = (0, _public.useChartThemes)();
  const maxLatency = Math.max(...items.map(item => {
    var _item$latency;
    return (_item$latency = item.latency) !== null && _item$latency !== void 0 ? _item$latency : 0;
  }));
  const latencyFormatter = (0, _formatters.getDurationFormatter)(maxLatency);
  const tooltip = {
    stickTo: 'center',
    type: _charts.TooltipType.Follow,
    snap: false,
    customTooltip: props => /*#__PURE__*/_react.default.createElement(_custom_tooltip.CustomTooltip, (0, _extends2.default)({}, props, {
      latencyFormatter: latencyFormatter,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 7
      }
    }))
  };

  /**
   * Handle click events on the items.
   *
   * Due to how we handle filtering by using the kuery bar, it's difficult to
   * modify existing queries. If you have an existing query in the bar, this will
   * wipe it out. This is ok for now, since we probably will be replacing this
   * interaction with something nicer in a future release.
   *
   * The event object has an array two items for each point, one of which has
   * the serviceNodeName, so we flatten the list and get the items we need to
   * form a query.
   */
  const handleElementClick = event => {
    const serviceNodeNamesQuery = event.flat().flatMap(value => {
      var _datum;
      return (_datum = value.datum) === null || _datum === void 0 ? void 0 : _datum.serviceNodeName;
    }).filter(serviceNodeName => !!serviceNodeName).map(serviceNodeName => `${_apm.SERVICE_NODE_NAME}:"${serviceNodeName}"`).join(' OR ');
    urlHelpers.push(history, {
      query: {
        kuery: serviceNodeNamesQuery
      }
    });
  };

  // With a linear scale, if all the instances have similar throughput (or if
  // there's just a single instance) they'll show along the origin. Make sure
  // the x-axis domain is [0, maxThroughput].
  const maxThroughput = Math.max(...items.map(item => {
    var _item$throughput;
    return (_item$throughput = item.throughput) !== null && _item$throughput !== void 0 ? _item$throughput : 0;
  }));
  const maxComparisonThroughput = Math.max(...comparisonItems.map(item => {
    var _item$throughput2;
    return (_item$throughput2 = item.throughput) !== null && _item$throughput2 !== void 0 ? _item$throughput2 : 0;
  }));
  const xDomain = {
    min: 0,
    max: Math.max(maxThroughput, maxComparisonThroughput)
  };
  const previousPeriodLabel = (0, _use_previous_period_text.usePreviousPeriodLabel)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("h2", {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 9
    }
  }, _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTitle', {
    defaultMessage: 'Instances latency distribution'
  }))), /*#__PURE__*/_react.default.createElement(_chart_container.ChartContainer, {
    hasData: hasData,
    height: height,
    status: status,
    id: "instancesLatencyDistribution",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 116,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, (0, _extends2.default)({}, tooltip, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 123,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    legendPosition: _charts.Position.Bottom,
    onElementClick: handleElementClick,
    showLegend: true,
    theme: chartThemes.theme,
    baseTheme: chartThemes.baseTheme,
    xDomain: xDomain,
    locale: _i18n.i18n.getLocale(),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.BubbleSeries, {
    color: euiTheme.colors.vis.euiColorVis0,
    data: items,
    id: _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartLegend', {
      defaultMessage: 'Instances'
    }),
    xAccessor: item => item.throughput,
    xScaleType: _charts.ScaleType.Linear,
    yAccessors: [item => item.latency],
    yScaleType: _charts.ScaleType.Linear,
    bubbleSeriesStyle: {
      point: {
        strokeWidth: 0,
        radius: 4,
        fill: euiTheme.colors.vis.euiColorVis0
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 11
    }
  }), !!comparisonItems.length && /*#__PURE__*/_react.default.createElement(_charts.BubbleSeries, {
    data: comparisonItems,
    id: previousPeriodLabel,
    xAccessor: item => item.throughput,
    xScaleType: _charts.ScaleType.Linear,
    yAccessors: [item => item.latency],
    yScaleType: _charts.ScaleType.Linear,
    color: euiTheme.colors.mediumShade,
    bubbleSeriesStyle: {
      point: {
        shape: 'square',
        radius: 4,
        fill: euiTheme.colors.lightestShade,
        stroke: euiTheme.colors.mediumShade,
        strokeWidth: 2
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "x-axis",
    labelFormat: _formatters.asTransactionRate,
    position: _charts.Position.Bottom,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 11
    }
  }), /*#__PURE__*/_react.default.createElement(_charts.Axis, {
    id: "y-axis",
    labelFormat: (0, _helper.getResponseTimeTickFormatter)(latencyFormatter),
    position: _charts.Position.Left,
    ticks: 3,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 11
    }
  }))));
}