"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomalyRuleType = AnomalyRuleType;
exports.default = void 0;
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
var _public2 = require("@kbn/triggers-actions-ui-plugin/public");
var _anomaly_severity = require("@kbn/ml-anomaly-utils/anomaly_severity");
var _eui = require("@elastic/eui");
var _environment_filter_values = require("../../../../../common/environment_filter_values");
var _create_call_apm_api = require("../../../../services/rest/create_call_apm_api");
var _fields = require("../../utils/fields");
var _apm_rule_params_container = require("../../ui_components/apm_rule_params_container");
var _popover_expression = require("../../ui_components/popover_expression");
var _select_anomaly_severity = require("./select_anomaly_severity");
var _select_anomaly_detector = require("./select_anomaly_detector");
var _apm_rule_types = require("../../../../../common/rules/apm_rule_types");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763813011435175369/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/alerting/rule_types/anomaly_rule_type/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AnomalyRuleType(props) {
  const {
    services
  } = (0, _public.useKibana)();
  const {
    ruleParams,
    metadata,
    setRuleParams,
    setRuleProperty
  } = props;
  (0, _react.useEffect)(() => {
    (0, _create_call_apm_api.createCallApmApi)(services);
  }, [services]);
  const params = (0, _lodash.defaults)({
    ...(0, _lodash.omit)(metadata, ['start', 'end']),
    ...ruleParams
  }, {
    windowSize: 30,
    windowUnit: _public2.TIME_UNITS.MINUTE,
    anomalySeverityType: _anomaly_severity.ML_ANOMALY_SEVERITY.CRITICAL,
    anomalyDetectorTypes: _apm_rule_types.ANOMALY_DETECTOR_SELECTOR_OPTIONS.map(detector => detector.type),
    environment: _environment_filter_values.ENVIRONMENT_ALL.value
  });
  const anomalyDetectorsSelectedLabels = params.anomalyDetectorTypes.map(type => (0, _apm_rule_types.getApmMlDetectorLabel)(type));
  const fields = [/*#__PURE__*/_react.default.createElement(_fields.ServiceField, {
    currentValue: params.serviceName,
    onChange: value => {
      if (value !== params.serviceName) {
        setRuleParams('serviceName', value);
        setRuleParams('transactionType', '');
        setRuleParams('environment', _environment_filter_values.ENVIRONMENT_ALL.value);
      }
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.TransactionTypeField, {
    currentValue: params.transactionType,
    onChange: value => setRuleParams('transactionType', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_fields.EnvironmentField, {
    currentValue: params.environment,
    onChange: value => setRuleParams('environment', value),
    serviceName: params.serviceName,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 94,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: anomalyDetectorsSelectedLabels.join(', '),
    title: _i18n.i18n.translate('xpack.apm.anomalyRuleType.anomalyDetector', {
      defaultMessage: 'Detector types'
    }),
    color: props.errors.anomalyDetectorTypes ? 'danger' : 'success',
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 5
    }
  }, props.errors.anomalyDetectorTypes && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    color: "danger",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.apm.anomalyRuleType.anomalyDetector.infoLabel",
    defaultMessage: "At least one detector should be selected",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 11
    }
  })), /*#__PURE__*/_react.default.createElement(_select_anomaly_detector.SelectAnomalyDetector, {
    values: params.anomalyDetectorTypes,
    onChange: values => {
      setRuleParams('anomalyDetectorTypes', values);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 7
    }
  })), /*#__PURE__*/_react.default.createElement(_popover_expression.PopoverExpression, {
    value: /*#__PURE__*/_react.default.createElement(_select_anomaly_severity.AnomalySeverity, {
      type: params.anomalySeverityType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 14
      }
    }),
    title: _i18n.i18n.translate('xpack.apm.transactionDurationAnomalyRuleType.anomalySeverity', {
      defaultMessage: 'Has anomaly with severity'
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_select_anomaly_severity.SelectAnomalySeverity, {
    value: params.anomalySeverityType,
    onChange: value => {
      setRuleParams('anomalySeverityType', value);
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }))];
  return /*#__PURE__*/_react.default.createElement(_apm_rule_params_container.ApmRuleParamsContainer, {
    fields: fields,
    defaultParams: params,
    setRuleParams: setRuleParams,
    setRuleProperty: setRuleProperty,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 5
    }
  });
}

// Default export is required for React.lazy loading
//
// eslint-disable-next-line import/no-default-export
var _default = exports.default = AnomalyRuleType;