"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.mockHandlerArguments = mockHandlerArguments;
exports.mockResponseFactory = void 0;
var _lodash = require("lodash");
var _mocks = require("@kbn/core/server/mocks");
var _mocks2 = require("@kbn/actions-plugin/server/mocks");
var _rules_client = require("../rules_client.mock");
var _rules_settings_client = require("../rules_settings/rules_settings_client.mock");
var _maintenance_window_client = require("../maintenance_window_client.mock");
var _alert_deletion_client = require("../alert_deletion/alert_deletion_client.mock");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function mockHandlerArguments({
  rulesClient = _rules_client.rulesClientMock.create(),
  actionsClient = _mocks2.actionsClientMock.create(),
  rulesSettingsClient = _rules_settings_client.rulesSettingsClientMock.create(),
  maintenanceWindowClient = _maintenance_window_client.maintenanceWindowClientMock.create(),
  savedObjectsClient = _mocks.savedObjectsClientMock.create(),
  listTypes: listTypesRes = new Map(),
  getFrameworkHealth,
  areApiKeysEnabled,
  alertDeletionClient,
  hasRequiredPrivilegeGrantedInAllSpaces
}, request, response) {
  const listTypes = jest.fn(() => listTypesRes);
  const actionsClientMocked = actionsClient || _mocks2.actionsClientMock.create();
  actionsClient.isSystemAction.mockImplementation(id => id === 'system_action-id');
  const core = _mocks.coreMock.createRequestHandlerContext();
  core.savedObjects.getClient = jest.fn().mockReturnValue(savedObjectsClient);
  return [{
    alerting: {
      listTypes,
      getRulesClient() {
        return Promise.resolve(rulesClient || _rules_client.rulesClientMock.create());
      },
      getRulesSettingsClient() {
        return rulesSettingsClient || _rules_settings_client.rulesSettingsClientMock.create();
      },
      getMaintenanceWindowClient() {
        return maintenanceWindowClient || _maintenance_window_client.maintenanceWindowClientMock.create();
      },
      getFrameworkHealth,
      areApiKeysEnabled: areApiKeysEnabled ? areApiKeysEnabled : () => Promise.resolve(true),
      getAlertDeletionClient() {
        return alertDeletionClient || _alert_deletion_client.alertDeletionClientMock.create();
      },
      hasRequiredPrivilegeGrantedInAllSpaces: hasRequiredPrivilegeGrantedInAllSpaces ? hasRequiredPrivilegeGrantedInAllSpaces : () => {
        return Promise.resolve(true);
      }
    },
    actions: {
      getActionsClient() {
        return actionsClientMocked;
      }
    },
    core
  }, request, mockResponseFactory(response)];
}
const mockResponseFactory = (resToMock = []) => {
  const factory = _mocks.httpServerMock.createResponseFactory();
  resToMock.forEach(key => {
    if (key in factory) {
      Object.defineProperty(factory, key, {
        value: jest.fn(_lodash.identity)
      });
    }
  });
  return factory;
};
exports.mockResponseFactory = mockResponseFactory;