/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.Executor;
import java.util.function.BooleanSupplier;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.metadata.IndexMetadata;
import org.elasticsearch.cluster.metadata.Metadata;
import org.elasticsearch.cluster.metadata.ProjectId;
import org.elasticsearch.cluster.metadata.RepositoryMetadata;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.core.CheckedConsumer;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.snapshots.IndexShardSnapshotStatus;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.RepositoriesStats;
import org.elasticsearch.repositories.Repository;
import org.elasticsearch.repositories.RepositoryData;
import org.elasticsearch.repositories.RepositoryShardId;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.repositories.ShardSnapshotResult;
import org.elasticsearch.repositories.SnapshotShardContext;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.telemetry.metric.LongWithAttributes;

public abstract class RestoreOnlyRepository
extends AbstractLifecycleComponent
implements Repository {
    private final ProjectId projectId;
    private final String indexName;

    public RestoreOnlyRepository(ProjectId projectId, String indexName) {
        this.projectId = projectId;
        this.indexName = indexName;
    }

    protected void doStart() {
    }

    protected void doStop() {
    }

    protected void doClose() {
    }

    public ProjectId getProjectId() {
        return this.projectId;
    }

    public RepositoryMetadata getMetadata() {
        return null;
    }

    public void getSnapshotInfo(Collection<SnapshotId> snapshotIds, boolean abortOnFailure, BooleanSupplier isCancelled, CheckedConsumer<SnapshotInfo, Exception> consumer, ActionListener<Void> listener) {
        listener.onFailure((Exception)new UnsupportedOperationException());
    }

    public Metadata getSnapshotGlobalMetadata(SnapshotId snapshotId, boolean fromProjectMetadata) {
        return null;
    }

    public IndexMetadata getSnapshotIndexMetaData(RepositoryData repositoryData, SnapshotId snapshotId, IndexId index) {
        return null;
    }

    public void getRepositoryData(Executor responseExecutor, ActionListener<RepositoryData> listener) {
        IndexId indexId = new IndexId(this.indexName, "blah");
        listener.onResponse((Object)new RepositoryData("_na_", -1L, Collections.emptyMap(), Collections.emptyMap(), Collections.singletonMap(indexId, Collections.emptyList()), ShardGenerations.EMPTY, IndexMetaDataGenerations.EMPTY, "_na_"));
    }

    public void finalizeSnapshot(FinalizeSnapshotContext finalizeSnapshotContext) {
        finalizeSnapshotContext.onResponse(null);
    }

    public void deleteSnapshots(Collection<SnapshotId> snapshotIds, long repositoryDataGeneration, IndexVersion minimumNodeVersion, ActionListener<RepositoryData> repositoryDataUpdateListener, Runnable onCompletion) {
        repositoryDataUpdateListener.onFailure((Exception)new UnsupportedOperationException());
    }

    public String startVerification() {
        return null;
    }

    public void endVerification(String verificationToken) {
    }

    public boolean isReadOnly() {
        return false;
    }

    public void snapshotShard(SnapshotShardContext context) {
    }

    public IndexShardSnapshotStatus.Copy getShardSnapshotStatus(SnapshotId snapshotId, IndexId indexId, ShardId shardId) {
        return null;
    }

    public void verify(String verificationToken, DiscoveryNode localNode) {
    }

    public void updateState(ClusterState state) {
    }

    public void awaitIdle() {
    }

    public void cloneShardSnapshot(SnapshotId source, SnapshotId target, RepositoryShardId repositoryShardId, ShardGeneration shardGeneration, ActionListener<ShardSnapshotResult> listener) {
        throw new UnsupportedOperationException("Unsupported for restore-only repository");
    }

    public LongWithAttributes getShardSnapshotsInProgress() {
        return null;
    }

    public RepositoriesStats.SnapshotStats getSnapshotStats() {
        return RepositoriesStats.SnapshotStats.ZERO;
    }
}

