/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ml.action;

import java.io.IOException;
import java.util.Objects;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.ActionType;
import org.elasticsearch.action.support.IndicesOptions;
import org.elasticsearch.action.support.master.AcknowledgedRequest;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xpack.core.ml.datafeed.DatafeedConfig;

public class PutDatafeedAction
extends ActionType<Response> {
    public static final PutDatafeedAction INSTANCE = new PutDatafeedAction();
    public static final String NAME = "cluster:admin/xpack/ml/datafeeds/put";

    private PutDatafeedAction() {
        super(NAME);
    }

    public static class Response
    extends ActionResponse
    implements ToXContentObject {
        private final DatafeedConfig datafeed;

        public Response(DatafeedConfig datafeed) {
            this.datafeed = datafeed;
        }

        public Response(StreamInput in) throws IOException {
            this.datafeed = new DatafeedConfig(in);
        }

        public DatafeedConfig getResponse() {
            return this.datafeed;
        }

        public void writeTo(StreamOutput out) throws IOException {
            this.datafeed.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.datafeed.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Response response = (Response)((Object)o);
            return Objects.equals(this.datafeed, response.datafeed);
        }

        public int hashCode() {
            return Objects.hash(this.datafeed);
        }
    }

    public static class Request
    extends AcknowledgedRequest<Request>
    implements ToXContentObject {
        private final DatafeedConfig datafeed;

        public static Request parseRequest(String datafeedId, IndicesOptions indicesOptions, XContentParser parser) {
            DatafeedConfig.Builder datafeed = (DatafeedConfig.Builder)DatafeedConfig.STRICT_PARSER.apply(parser, null);
            if (datafeed.getIndicesOptions() == null) {
                datafeed.setIndicesOptions(indicesOptions);
            }
            datafeed.setId(datafeedId);
            return new Request(datafeed.build());
        }

        public Request(DatafeedConfig datafeed) {
            super(TRAPPY_IMPLICIT_DEFAULT_MASTER_NODE_TIMEOUT, DEFAULT_ACK_TIMEOUT);
            this.datafeed = datafeed;
        }

        public Request(StreamInput in) throws IOException {
            super(in);
            this.datafeed = new DatafeedConfig(in);
        }

        public DatafeedConfig getDatafeed() {
            return this.datafeed;
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.datafeed.writeTo(out);
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            this.datafeed.toXContent(builder, params);
            return builder;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
                return false;
            }
            Request request = (Request)((Object)o);
            return Objects.equals(this.datafeed, request.datafeed);
        }

        public int hashCode() {
            return Objects.hash(this.datafeed);
        }
    }
}

