/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.admin.cluster.stats;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.action.admin.cluster.stats.ExtendedSearchUsageMetric;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.XContentBuilder;

public class ExtendedSearchUsageLongCounter
implements ExtendedSearchUsageMetric<ExtendedSearchUsageLongCounter> {
    public static final String NAME = "extended_search_usage_long_counter";
    private final Map<String, Long> values;

    public ExtendedSearchUsageLongCounter(Map<String, Long> values) {
        this.values = values;
    }

    public ExtendedSearchUsageLongCounter(StreamInput in) throws IOException {
        this.values = in.readMap(StreamInput::readString, StreamInput::readLong);
    }

    public Map<String, Long> getValues() {
        return Collections.unmodifiableMap(this.values);
    }

    @Override
    public ExtendedSearchUsageLongCounter merge(ExtendedSearchUsageMetric<?> other) {
        assert (other instanceof ExtendedSearchUsageLongCounter);
        ExtendedSearchUsageLongCounter otherLongCounter = (ExtendedSearchUsageLongCounter)other;
        HashMap<String, Long> values = new HashMap<String, Long>(this.values);
        otherLongCounter.getValues().forEach((key, otherValue) -> values.merge((String)key, (Long)otherValue, Long::sum));
        return new ExtendedSearchUsageLongCounter(values);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeMap(this.values, StreamOutput::writeString, StreamOutput::writeLong);
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        for (String key : this.values.keySet()) {
            builder.field(key, this.values.get(key));
        }
        return builder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ExtendedSearchUsageLongCounter that = (ExtendedSearchUsageLongCounter)o;
        return Objects.equals(this.values, that.values);
    }

    public int hashCode() {
        return this.values.hashCode();
    }

    @Override
    public String getWriteableName() {
        return NAME;
    }
}

