/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.test.rest.yaml.section;

import java.io.IOException;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.test.rest.yaml.section.Assertion;
import org.elasticsearch.test.rest.yaml.section.ParserUtils;
import org.elasticsearch.xcontent.XContentLocation;
import org.elasticsearch.xcontent.XContentParser;
import org.junit.Assert;

public class IsAfterAssertion
extends Assertion {
    private static final Logger logger = LogManager.getLogger(IsAfterAssertion.class);

    public static IsAfterAssertion parse(XContentParser parser) throws IOException {
        XContentLocation location = parser.getTokenLocation();
        Tuple<String, Object> stringObjectTuple = ParserUtils.parseTuple(parser);
        return new IsAfterAssertion(location, (String)stringObjectTuple.v1(), stringObjectTuple.v2());
    }

    public IsAfterAssertion(XContentLocation location, String field, Object expectedValue) {
        super(location, field, expectedValue);
    }

    @Override
    protected void doAssert(Object actualValue, Object expectedValue) {
        Assert.assertNotNull((String)("field [" + this.getField() + "] is null"), (Object)actualValue);
        Assert.assertNotNull((String)"value to test against cannot be null", (Object)expectedValue);
        Instant fieldInstant = this.parseToInstant(actualValue.toString(), "field [" + this.getField() + "] cannot be parsed to " + Instant.class.getSimpleName() + ", got [" + String.valueOf(actualValue) + "]");
        Instant valueInstant = this.parseToInstant(expectedValue.toString(), "value to test against [" + String.valueOf(expectedValue) + "] cannot be parsed to " + Instant.class.getSimpleName());
        logger.trace("assert that [{}] is after [{}] (field [{}])", new Object[]{fieldInstant, valueInstant});
        Assert.assertTrue((String)("field [" + this.getField() + "] should be after [" + String.valueOf(actualValue) + "], but was not"), (boolean)fieldInstant.isAfter(valueInstant));
    }

    private Instant parseToInstant(String string, String onErrorMessage) {
        try {
            return Instant.parse(string);
        }
        catch (DateTimeParseException e) {
            throw new AssertionError(onErrorMessage, e);
        }
    }
}

