/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.security.authc.support.mapper;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.script.Script;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.script.TemplateScript;
import org.elasticsearch.xcontent.ConstructingObjectParser;
import org.elasticsearch.xcontent.ObjectParser;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentFactory;
import org.elasticsearch.xcontent.XContentParseException;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;
import org.elasticsearch.xcontent.json.JsonXContent;
import org.elasticsearch.xpack.core.security.authc.support.mapper.expressiondsl.ExpressionModel;
import org.elasticsearch.xpack.core.security.support.MustacheTemplateEvaluator;

public class TemplateRoleName
implements ToXContentObject,
Writeable {
    private static final ConstructingObjectParser<TemplateRoleName, Void> PARSER = new ConstructingObjectParser("role-mapping-template", false, arr -> new TemplateRoleName((BytesReference)arr[0], (Format)((Object)((Object)arr[1]))));
    private final BytesReference template;
    private final Format format;

    public TemplateRoleName(BytesReference template, Format format) {
        this.template = template;
        this.format = format == null ? Format.STRING : format;
    }

    public TemplateRoleName(StreamInput in) throws IOException {
        this.template = in.readBytesReference();
        this.format = in.readEnum(Format.class);
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        out.writeBytesReference(this.template);
        out.writeEnum(this.format);
    }

    public BytesReference getTemplate() {
        return this.template;
    }

    public Format getFormat() {
        return this.format;
    }

    public List<String> getRoleNames(ScriptService scriptService, ExpressionModel model) {
        try {
            String evaluation = this.parseTemplate(scriptService, model.asMap());
            return switch (this.format.ordinal()) {
                default -> throw new MatchException(null, null);
                case 1 -> Collections.singletonList(evaluation);
                case 0 -> TemplateRoleName.convertJsonToList(evaluation);
            };
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public void validate(ScriptService scriptService) {
        try {
            XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, this.template, XContentType.JSON);
            Script script = MustacheTemplateEvaluator.parseForScript(parser, Collections.emptyMap());
            TemplateScript compiledTemplate = scriptService.compile(script, TemplateScript.CONTEXT).newInstance(script.getParams());
            if ("mustache".equals(script.getLang())) {
                compiledTemplate.execute();
            }
        }
        catch (IllegalArgumentException e) {
            throw e;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
    }

    private static List<String> convertJsonToList(String evaluation) throws IOException {
        try (XContentParser parser = XContentFactory.xContent(XContentType.JSON).createParser(XContentParserConfiguration.EMPTY, evaluation);){
            XContentParser.Token token = parser.currentToken();
            if (token == null) {
                token = parser.nextToken();
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                List<String> list = Collections.singletonList(parser.text());
                return list;
            }
            if (token == XContentParser.Token.START_ARRAY) {
                List<String> list = parser.list().stream().filter(Objects::nonNull).map(o -> {
                    if (o instanceof String) {
                        return (String)o;
                    }
                    throw new XContentParseException("Roles array may only contain strings but found [" + o.getClass().getName() + "] [" + String.valueOf(o) + "]");
                }).collect(Collectors.toList());
                return list;
            }
            throw new XContentParseException("Roles template must generate a string or an array of strings, but found [" + String.valueOf((Object)token) + "]");
        }
    }

    private String parseTemplate(ScriptService scriptService, Map<String, Object> parameters) throws IOException {
        try (XContentParser parser = XContentHelper.createParser(XContentParserConfiguration.EMPTY, this.template, XContentType.JSON);){
            String string = MustacheTemplateEvaluator.evaluate(scriptService, parser, parameters);
            return string;
        }
    }

    private static BytesReference extractTemplate(XContentParser parser, Void ignore) throws IOException {
        if (parser.currentToken() == XContentParser.Token.VALUE_STRING) {
            return new BytesArray(parser.text());
        }
        XContentBuilder builder = JsonXContent.contentBuilder();
        builder.generator().copyCurrentStructure(parser);
        return BytesReference.bytes(builder);
    }

    static TemplateRoleName parse(XContentParser parser) throws IOException {
        return PARSER.parse(parser, null);
    }

    public String toString() {
        return "template-" + String.valueOf((Object)this.format) + "{" + this.template.utf8ToString() + "}";
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        return builder.startObject().field(Fields.TEMPLATE.getPreferredName(), this.template.utf8ToString()).field(Fields.FORMAT.getPreferredName(), this.format.formatName()).endObject();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TemplateRoleName that = (TemplateRoleName)o;
        return Objects.equals(this.template, that.template) && this.format == that.format;
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.template, this.format});
    }

    static {
        PARSER.declareField(ConstructingObjectParser.constructorArg(), TemplateRoleName::extractTemplate, Fields.TEMPLATE, ObjectParser.ValueType.OBJECT_OR_STRING);
        PARSER.declareField(ConstructingObjectParser.optionalConstructorArg(), Format::fromXContent, Fields.FORMAT, ObjectParser.ValueType.STRING);
    }

    public static enum Format {
        JSON,
        STRING;


        private static Format fromXContent(XContentParser parser) throws IOException {
            XContentParser.Token token = parser.currentToken();
            if (token != XContentParser.Token.VALUE_STRING) {
                throw new XContentParseException(parser.getTokenLocation(), "Expected [" + String.valueOf((Object)XContentParser.Token.VALUE_STRING) + "] but found [" + String.valueOf((Object)token) + "]");
            }
            String text = parser.text();
            try {
                return Format.valueOf(text.toUpperCase(Locale.ROOT));
            }
            catch (IllegalArgumentException e) {
                String valueNames = Stream.of(Format.values()).map(Format::formatName).collect(Collectors.joining(","));
                throw new XContentParseException(parser.getTokenLocation(), "Invalid format [" + text + "] expected one of [" + valueNames + "]");
            }
        }

        public String formatName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static interface Fields {
        public static final ParseField TEMPLATE = new ParseField("template", new String[0]);
        public static final ParseField FORMAT = new ParseField("format", new String[0]);
    }
}

