/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.core.ilm;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.TransportVersion;
import org.elasticsearch.TransportVersions;
import org.elasticsearch.action.admin.indices.rollover.RolloverConditions;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.io.stream.Writeable;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.xcontent.ParseField;
import org.elasticsearch.xcontent.ToXContent;
import org.elasticsearch.xcontent.ToXContentObject;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xpack.core.XPackFeatureUsage;
import org.elasticsearch.xpack.core.ilm.AllocateAction;
import org.elasticsearch.xpack.core.ilm.ForceMergeAction;
import org.elasticsearch.xpack.core.ilm.LifecyclePolicy;
import org.elasticsearch.xpack.core.ilm.Phase;
import org.elasticsearch.xpack.core.ilm.SetPriorityAction;
import org.elasticsearch.xpack.core.ilm.ShrinkAction;

public class IndexLifecycleFeatureSetUsage
extends XPackFeatureUsage {
    private List<PolicyStats> policyStats;

    public IndexLifecycleFeatureSetUsage(StreamInput input) throws IOException {
        super(input);
        if (input.readBoolean()) {
            this.policyStats = input.readCollectionAsList(PolicyStats::new);
        }
    }

    @Override
    public TransportVersion getMinimalSupportedVersion() {
        return TransportVersion.zero();
    }

    @Override
    public void writeTo(StreamOutput out) throws IOException {
        super.writeTo(out);
        boolean hasPolicyStats = this.policyStats != null;
        out.writeBoolean(hasPolicyStats);
        if (hasPolicyStats) {
            out.writeCollection(this.policyStats);
        }
    }

    public IndexLifecycleFeatureSetUsage() {
        this((List<PolicyStats>)null);
    }

    public IndexLifecycleFeatureSetUsage(List<PolicyStats> policyStats) {
        super("ilm", true, true);
        this.policyStats = policyStats;
    }

    @Override
    protected void innerXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        if (this.policyStats != null) {
            builder.field("policy_count", this.policyStats.size());
            builder.xContentList("policy_stats", this.policyStats);
        }
    }

    public List<PolicyStats> getPolicyStats() {
        return this.policyStats;
    }

    public int hashCode() {
        return Objects.hash(this.available, this.enabled, this.policyStats);
    }

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IndexLifecycleFeatureSetUsage other = (IndexLifecycleFeatureSetUsage)obj;
        return Objects.equals(this.available, other.available) && Objects.equals(this.enabled, other.enabled) && Objects.equals(this.policyStats, other.policyStats);
    }

    public static final class ActionConfigStats
    implements ToXContentObject,
    Writeable {
        private final Integer allocateNumberOfReplicas;
        private final Integer forceMergeMaxNumberOfSegments;
        private final TimeValue rolloverMaxAge;
        private final Long rolloverMaxDocs;
        private final Long rolloverMaxPrimaryShardDocs;
        private final ByteSizeValue rolloverMaxPrimaryShardSize;
        private final ByteSizeValue rolloverMaxSize;
        private final TimeValue rolloverMinAge;
        private final Long rolloverMinDocs;
        private final Long rolloverMinPrimaryShardDocs;
        private final ByteSizeValue rolloverMinPrimaryShardSize;
        private final ByteSizeValue rolloverMinSize;
        private final Integer setPriorityPriority;
        private final ByteSizeValue shrinkMaxPrimaryShardSize;
        private final Integer shrinkNumberOfShards;

        public static Builder builder() {
            return new Builder();
        }

        public static Builder builder(ActionConfigStats existing) {
            return new Builder(existing);
        }

        public ActionConfigStats(Integer allocateNumberOfReplicas, Integer forceMergeMaxNumberOfSegments, TimeValue rolloverMaxAge, Long rolloverMaxDocs, Long rolloverMaxPrimaryShardDocs, ByteSizeValue rolloverMaxPrimaryShardSize, ByteSizeValue rolloverMaxSize, TimeValue rolloverMinAge, Long rolloverMinDocs, Long rolloverMinPrimaryShardDocs, ByteSizeValue rolloverMinPrimaryShardSize, ByteSizeValue rolloverMinSize, Integer setPriorityPriority, ByteSizeValue shrinkMaxPrimaryShardSize, Integer shrinkNumberOfShards) {
            this.allocateNumberOfReplicas = allocateNumberOfReplicas;
            this.forceMergeMaxNumberOfSegments = forceMergeMaxNumberOfSegments;
            this.rolloverMaxAge = rolloverMaxAge;
            this.rolloverMaxDocs = rolloverMaxDocs;
            this.rolloverMaxPrimaryShardDocs = rolloverMaxPrimaryShardDocs;
            this.rolloverMaxPrimaryShardSize = rolloverMaxPrimaryShardSize;
            this.rolloverMaxSize = rolloverMaxSize;
            this.rolloverMinAge = rolloverMinAge;
            this.rolloverMinDocs = rolloverMinDocs;
            this.rolloverMinPrimaryShardDocs = rolloverMinPrimaryShardDocs;
            this.rolloverMinPrimaryShardSize = rolloverMinPrimaryShardSize;
            this.rolloverMinSize = rolloverMinSize;
            this.setPriorityPriority = setPriorityPriority;
            this.shrinkMaxPrimaryShardSize = shrinkMaxPrimaryShardSize;
            this.shrinkNumberOfShards = shrinkNumberOfShards;
        }

        public ActionConfigStats(StreamInput in) throws IOException {
            this.allocateNumberOfReplicas = in.readOptionalVInt();
            this.forceMergeMaxNumberOfSegments = in.readOptionalVInt();
            this.rolloverMaxAge = in.readOptionalTimeValue();
            this.rolloverMaxDocs = in.readOptionalVLong();
            this.rolloverMaxPrimaryShardSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.rolloverMaxSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.setPriorityPriority = in.readOptionalVInt();
            this.shrinkMaxPrimaryShardSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
            this.shrinkNumberOfShards = in.readOptionalVInt();
            this.rolloverMaxPrimaryShardDocs = in.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0) ? in.readOptionalVLong() : null;
            if (in.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
                this.rolloverMinAge = in.readOptionalTimeValue();
                this.rolloverMinDocs = in.readOptionalVLong();
                this.rolloverMinPrimaryShardSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
                this.rolloverMinSize = in.readOptionalWriteable(ByteSizeValue::readFrom);
                this.rolloverMinPrimaryShardDocs = in.readOptionalVLong();
            } else {
                this.rolloverMinAge = null;
                this.rolloverMinDocs = null;
                this.rolloverMinPrimaryShardSize = null;
                this.rolloverMinSize = null;
                this.rolloverMinPrimaryShardDocs = null;
            }
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeOptionalVInt(this.allocateNumberOfReplicas);
            out.writeOptionalVInt(this.forceMergeMaxNumberOfSegments);
            out.writeOptionalTimeValue(this.rolloverMaxAge);
            out.writeOptionalVLong(this.rolloverMaxDocs);
            out.writeOptionalWriteable(this.rolloverMaxPrimaryShardSize);
            out.writeOptionalWriteable(this.rolloverMaxSize);
            out.writeOptionalVInt(this.setPriorityPriority);
            out.writeOptionalWriteable(this.shrinkMaxPrimaryShardSize);
            out.writeOptionalVInt(this.shrinkNumberOfShards);
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_2_0)) {
                out.writeOptionalVLong(this.rolloverMaxPrimaryShardDocs);
            }
            if (out.getTransportVersion().onOrAfter(TransportVersions.V_8_4_0)) {
                out.writeOptionalTimeValue(this.rolloverMinAge);
                out.writeOptionalVLong(this.rolloverMinDocs);
                out.writeOptionalWriteable(this.rolloverMinPrimaryShardSize);
                out.writeOptionalWriteable(this.rolloverMinSize);
                out.writeOptionalVLong(this.rolloverMinPrimaryShardDocs);
            }
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            if (this.allocateNumberOfReplicas != null) {
                builder.startObject("allocate");
                builder.field(AllocateAction.NUMBER_OF_REPLICAS_FIELD.getPreferredName(), this.allocateNumberOfReplicas);
                builder.endObject();
            }
            if (this.forceMergeMaxNumberOfSegments != null) {
                builder.startObject("forcemerge");
                builder.field(ForceMergeAction.MAX_NUM_SEGMENTS_FIELD.getPreferredName(), this.forceMergeMaxNumberOfSegments);
                builder.endObject();
            }
            if (this.rolloverMaxAge != null || this.rolloverMaxDocs != null || this.rolloverMaxPrimaryShardDocs != null || this.rolloverMaxSize != null || this.rolloverMaxPrimaryShardSize != null || this.rolloverMinAge != null || this.rolloverMinDocs != null || this.rolloverMinPrimaryShardDocs != null || this.rolloverMinSize != null || this.rolloverMinPrimaryShardSize != null) {
                builder.startObject("rollover");
                if (this.rolloverMaxAge != null) {
                    builder.field(RolloverConditions.MAX_AGE_FIELD.getPreferredName(), this.rolloverMaxAge.getStringRep());
                    builder.field(RolloverConditions.MAX_AGE_FIELD.getPreferredName() + "_millis", this.rolloverMaxAge.getMillis());
                }
                if (this.rolloverMaxDocs != null) {
                    builder.field(RolloverConditions.MAX_DOCS_FIELD.getPreferredName(), this.rolloverMaxDocs);
                }
                if (this.rolloverMaxPrimaryShardDocs != null) {
                    builder.field(RolloverConditions.MAX_PRIMARY_SHARD_DOCS_FIELD.getPreferredName(), this.rolloverMaxPrimaryShardDocs);
                }
                if (this.rolloverMaxSize != null) {
                    builder.field(RolloverConditions.MAX_SIZE_FIELD.getPreferredName(), this.rolloverMaxSize.getStringRep());
                    builder.field(RolloverConditions.MAX_SIZE_FIELD.getPreferredName() + "_bytes", this.rolloverMaxSize.getBytes());
                }
                if (this.rolloverMaxPrimaryShardSize != null) {
                    builder.field(RolloverConditions.MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName(), this.rolloverMaxPrimaryShardSize.getStringRep());
                    builder.field(RolloverConditions.MAX_PRIMARY_SHARD_SIZE_FIELD.getPreferredName() + "_bytes", this.rolloverMaxPrimaryShardSize.getBytes());
                }
                if (this.rolloverMinAge != null) {
                    builder.field(RolloverConditions.MIN_AGE_FIELD.getPreferredName(), this.rolloverMinAge.getStringRep());
                    builder.field(RolloverConditions.MIN_AGE_FIELD.getPreferredName() + "_millis", this.rolloverMinAge.getMillis());
                }
                if (this.rolloverMinDocs != null) {
                    builder.field(RolloverConditions.MIN_DOCS_FIELD.getPreferredName(), this.rolloverMinDocs);
                }
                if (this.rolloverMinPrimaryShardDocs != null) {
                    builder.field(RolloverConditions.MIN_PRIMARY_SHARD_DOCS_FIELD.getPreferredName(), this.rolloverMinPrimaryShardDocs);
                }
                if (this.rolloverMinSize != null) {
                    builder.field(RolloverConditions.MIN_SIZE_FIELD.getPreferredName(), this.rolloverMinSize.getStringRep());
                    builder.field(RolloverConditions.MIN_SIZE_FIELD.getPreferredName() + "_bytes", this.rolloverMinSize.getBytes());
                }
                if (this.rolloverMinPrimaryShardSize != null) {
                    builder.field(RolloverConditions.MIN_PRIMARY_SHARD_SIZE_FIELD.getPreferredName(), this.rolloverMinPrimaryShardSize.getStringRep());
                    builder.field(RolloverConditions.MIN_PRIMARY_SHARD_SIZE_FIELD.getPreferredName() + "_bytes", this.rolloverMinPrimaryShardSize.getBytes());
                }
                builder.endObject();
            }
            if (this.setPriorityPriority != null) {
                builder.startObject("set_priority");
                builder.field(SetPriorityAction.RECOVERY_PRIORITY_FIELD.getPreferredName(), this.setPriorityPriority);
                builder.endObject();
            }
            if (this.shrinkMaxPrimaryShardSize != null || this.shrinkNumberOfShards != null) {
                builder.startObject("shrink");
                if (this.shrinkMaxPrimaryShardSize != null) {
                    builder.field(ShrinkAction.MAX_PRIMARY_SHARD_SIZE.getPreferredName(), this.shrinkMaxPrimaryShardSize.getStringRep());
                    builder.field(ShrinkAction.MAX_PRIMARY_SHARD_SIZE.getPreferredName() + "_bytes", this.shrinkMaxPrimaryShardSize.getBytes());
                }
                if (this.shrinkNumberOfShards != null) {
                    builder.field(ShrinkAction.NUMBER_OF_SHARDS_FIELD.getPreferredName(), this.shrinkNumberOfShards);
                }
                builder.endObject();
            }
            builder.endObject();
            return builder;
        }

        public Integer getAllocateNumberOfReplicas() {
            return this.allocateNumberOfReplicas;
        }

        public Integer getForceMergeMaxNumberOfSegments() {
            return this.forceMergeMaxNumberOfSegments;
        }

        public TimeValue getRolloverMaxAge() {
            return this.rolloverMaxAge;
        }

        public Long getRolloverMaxDocs() {
            return this.rolloverMaxDocs;
        }

        public Long getRolloverMaxPrimaryShardDocs() {
            return this.rolloverMaxPrimaryShardDocs;
        }

        public ByteSizeValue getRolloverMaxPrimaryShardSize() {
            return this.rolloverMaxPrimaryShardSize;
        }

        public ByteSizeValue getRolloverMaxSize() {
            return this.rolloverMaxSize;
        }

        public TimeValue getRolloverMinAge() {
            return this.rolloverMinAge;
        }

        public Long getRolloverMinDocs() {
            return this.rolloverMinDocs;
        }

        public Long getRolloverMinPrimaryShardDocs() {
            return this.rolloverMinPrimaryShardDocs;
        }

        public ByteSizeValue getRolloverMinPrimaryShardSize() {
            return this.rolloverMinPrimaryShardSize;
        }

        public ByteSizeValue getRolloverMinSize() {
            return this.rolloverMinSize;
        }

        public Integer getSetPriorityPriority() {
            return this.setPriorityPriority;
        }

        public ByteSizeValue getShrinkMaxPrimaryShardSize() {
            return this.shrinkMaxPrimaryShardSize;
        }

        public Integer getShrinkNumberOfShards() {
            return this.shrinkNumberOfShards;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ActionConfigStats that = (ActionConfigStats)o;
            return Objects.equals(this.allocateNumberOfReplicas, that.allocateNumberOfReplicas) && Objects.equals(this.forceMergeMaxNumberOfSegments, that.forceMergeMaxNumberOfSegments) && Objects.equals(this.rolloverMaxAge, that.rolloverMaxAge) && Objects.equals(this.rolloverMaxDocs, that.rolloverMaxDocs) && Objects.equals(this.rolloverMaxPrimaryShardDocs, that.rolloverMaxPrimaryShardDocs) && Objects.equals(this.rolloverMaxSize, that.rolloverMaxSize) && Objects.equals(this.rolloverMaxPrimaryShardSize, that.rolloverMaxPrimaryShardSize) && Objects.equals(this.rolloverMinAge, that.rolloverMinAge) && Objects.equals(this.rolloverMinDocs, that.rolloverMinDocs) && Objects.equals(this.rolloverMinPrimaryShardDocs, that.rolloverMinPrimaryShardDocs) && Objects.equals(this.rolloverMinSize, that.rolloverMinSize) && Objects.equals(this.rolloverMinPrimaryShardSize, that.rolloverMinPrimaryShardSize) && Objects.equals(this.setPriorityPriority, that.setPriorityPriority) && Objects.equals(this.shrinkMaxPrimaryShardSize, that.shrinkMaxPrimaryShardSize) && Objects.equals(this.shrinkNumberOfShards, that.shrinkNumberOfShards);
        }

        public int hashCode() {
            return Objects.hash(this.allocateNumberOfReplicas, this.forceMergeMaxNumberOfSegments, this.rolloverMaxAge, this.rolloverMaxDocs, this.rolloverMaxPrimaryShardDocs, this.rolloverMaxSize, this.rolloverMaxPrimaryShardSize, this.rolloverMinAge, this.rolloverMinDocs, this.rolloverMinPrimaryShardDocs, this.rolloverMinSize, this.rolloverMinPrimaryShardSize, this.setPriorityPriority, this.shrinkMaxPrimaryShardSize, this.shrinkNumberOfShards);
        }

        public static final class Builder {
            private Integer allocateNumberOfReplicas;
            private Integer forceMergeMaxNumberOfSegments;
            private TimeValue rolloverMaxAge;
            private Long rolloverMaxDocs;
            private Long rolloverMaxPrimaryShardDocs;
            private ByteSizeValue rolloverMaxPrimaryShardSize;
            private ByteSizeValue rolloverMaxSize;
            private TimeValue rolloverMinAge;
            private Long rolloverMinDocs;
            private Long rolloverMinPrimaryShardDocs;
            private ByteSizeValue rolloverMinPrimaryShardSize;
            private ByteSizeValue rolloverMinSize;
            private Integer setPriorityPriority;
            private ByteSizeValue shrinkMaxPrimaryShardSize;
            private Integer shrinkNumberOfShards;

            public Builder() {
            }

            public Builder(ActionConfigStats existing) {
                this.allocateNumberOfReplicas = existing.allocateNumberOfReplicas;
                this.forceMergeMaxNumberOfSegments = existing.forceMergeMaxNumberOfSegments;
                this.rolloverMaxAge = existing.rolloverMaxAge;
                this.rolloverMaxDocs = existing.rolloverMaxDocs;
                this.rolloverMaxPrimaryShardDocs = existing.rolloverMaxPrimaryShardDocs;
                this.rolloverMaxPrimaryShardSize = existing.rolloverMaxPrimaryShardSize;
                this.rolloverMaxSize = existing.rolloverMaxSize;
                this.rolloverMinAge = existing.rolloverMinAge;
                this.rolloverMinDocs = existing.rolloverMinDocs;
                this.rolloverMinPrimaryShardDocs = existing.rolloverMinPrimaryShardDocs;
                this.rolloverMinPrimaryShardSize = existing.rolloverMinPrimaryShardSize;
                this.rolloverMinSize = existing.rolloverMinSize;
                this.setPriorityPriority = existing.setPriorityPriority;
                this.shrinkMaxPrimaryShardSize = existing.shrinkMaxPrimaryShardSize;
                this.shrinkNumberOfShards = existing.shrinkNumberOfShards;
            }

            public Builder setAllocateNumberOfReplicas(Integer allocateNumberOfReplicas) {
                this.allocateNumberOfReplicas = allocateNumberOfReplicas;
                return this;
            }

            public Builder setForceMergeMaxNumberOfSegments(Integer forceMergeMaxNumberOfSegments) {
                this.forceMergeMaxNumberOfSegments = forceMergeMaxNumberOfSegments;
                return this;
            }

            public Builder setRolloverMaxAge(TimeValue rolloverMaxAge) {
                this.rolloverMaxAge = rolloverMaxAge;
                return this;
            }

            public Builder setRolloverMaxDocs(Long rolloverMaxDocs) {
                this.rolloverMaxDocs = rolloverMaxDocs;
                return this;
            }

            public Builder setRolloverMaxPrimaryShardDocs(Long rolloverMaxPrimaryShardDocs) {
                this.rolloverMaxPrimaryShardDocs = rolloverMaxPrimaryShardDocs;
                return this;
            }

            public Builder setRolloverMaxPrimaryShardSize(ByteSizeValue rolloverMaxPrimaryShardSize) {
                this.rolloverMaxPrimaryShardSize = rolloverMaxPrimaryShardSize;
                return this;
            }

            public Builder setRolloverMaxSize(ByteSizeValue rolloverMaxSize) {
                this.rolloverMaxSize = rolloverMaxSize;
                return this;
            }

            public Builder setRolloverMinAge(TimeValue rolloverMinAge) {
                this.rolloverMinAge = rolloverMinAge;
                return this;
            }

            public Builder setRolloverMinDocs(Long rolloverMinDocs) {
                this.rolloverMinDocs = rolloverMinDocs;
                return this;
            }

            public Builder setRolloverMinPrimaryShardDocs(Long rolloverMinPrimaryShardDocs) {
                this.rolloverMinPrimaryShardDocs = rolloverMinPrimaryShardDocs;
                return this;
            }

            public Builder setRolloverMinPrimaryShardSize(ByteSizeValue rolloverMinPrimaryShardSize) {
                this.rolloverMinPrimaryShardSize = rolloverMinPrimaryShardSize;
                return this;
            }

            public Builder setRolloverMinSize(ByteSizeValue rolloverMinSize) {
                this.rolloverMinSize = rolloverMinSize;
                return this;
            }

            public Builder setPriority(Integer priority) {
                this.setPriorityPriority = priority;
                return this;
            }

            public Builder setShrinkMaxPrimaryShardSize(ByteSizeValue shrinkMaxPrimaryShardSize) {
                this.shrinkMaxPrimaryShardSize = shrinkMaxPrimaryShardSize;
                return this;
            }

            public Builder setShrinkNumberOfShards(Integer shrinkNumberOfShards) {
                this.shrinkNumberOfShards = shrinkNumberOfShards;
                return this;
            }

            public ActionConfigStats build() {
                return new ActionConfigStats(this.allocateNumberOfReplicas, this.forceMergeMaxNumberOfSegments, this.rolloverMaxAge, this.rolloverMaxDocs, this.rolloverMaxPrimaryShardDocs, this.rolloverMaxPrimaryShardSize, this.rolloverMaxSize, this.rolloverMinAge, this.rolloverMinDocs, this.rolloverMinPrimaryShardDocs, this.rolloverMinPrimaryShardSize, this.rolloverMinSize, this.setPriorityPriority, this.shrinkMaxPrimaryShardSize, this.shrinkNumberOfShards);
            }
        }
    }

    public static final class PhaseStats
    implements ToXContentObject,
    Writeable {
        public static final ParseField CONFIGURATIONS_FIELD = new ParseField("configurations", new String[0]);
        private final String[] actionNames;
        private final ActionConfigStats configurations;
        private final TimeValue minimumAge;

        public PhaseStats(TimeValue after, String[] actionNames, ActionConfigStats configurations) {
            this.actionNames = Objects.requireNonNull(actionNames, "Missing required action names");
            this.configurations = Objects.requireNonNull(configurations, "Missing required action configurations");
            this.minimumAge = Objects.requireNonNull(after, "Missing required minimum age");
        }

        public PhaseStats(StreamInput in) throws IOException {
            this.actionNames = in.readStringArray();
            this.minimumAge = in.readTimeValue();
            this.configurations = new ActionConfigStats(in);
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeStringArray(this.actionNames);
            out.writeTimeValue(this.minimumAge);
            this.configurations.writeTo(out);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(Phase.MIN_AGE.getPreferredName(), this.minimumAge.getMillis());
            builder.field(Phase.ACTIONS_FIELD.getPreferredName(), this.actionNames);
            builder.field(CONFIGURATIONS_FIELD.getPreferredName(), this.configurations);
            builder.endObject();
            return builder;
        }

        public String[] getActionNames() {
            return this.actionNames;
        }

        public TimeValue getAfter() {
            return this.minimumAge;
        }

        public ActionConfigStats getConfigurations() {
            return this.configurations;
        }

        public int hashCode() {
            return Objects.hash(Arrays.hashCode(this.actionNames), this.configurations, this.minimumAge);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PhaseStats other = (PhaseStats)obj;
            return Objects.equals(this.minimumAge, other.minimumAge) && Objects.deepEquals(this.configurations, other.configurations) && Objects.deepEquals(this.actionNames, other.actionNames);
        }
    }

    public static final class PolicyStats
    implements ToXContentObject,
    Writeable {
        public static final ParseField INDICES_MANAGED_FIELD = new ParseField("indices_managed", new String[0]);
        private final Map<String, PhaseStats> phaseStats;
        private final int indicesManaged;

        public PolicyStats(Map<String, PhaseStats> phaseStats, int numberIndicesManaged) {
            this.phaseStats = phaseStats;
            this.indicesManaged = numberIndicesManaged;
        }

        public PolicyStats(StreamInput in) throws IOException {
            this.phaseStats = in.readMap(PhaseStats::new);
            this.indicesManaged = in.readVInt();
        }

        @Override
        public void writeTo(StreamOutput out) throws IOException {
            out.writeMap(this.phaseStats, StreamOutput::writeWriteable);
            out.writeVInt(this.indicesManaged);
        }

        @Override
        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            builder.startObject();
            builder.field(LifecyclePolicy.PHASES_FIELD.getPreferredName(), this.phaseStats);
            builder.field(INDICES_MANAGED_FIELD.getPreferredName(), this.indicesManaged);
            builder.endObject();
            return builder;
        }

        public Map<String, PhaseStats> getPhaseStats() {
            return this.phaseStats;
        }

        public int getIndicesManaged() {
            return this.indicesManaged;
        }

        public int hashCode() {
            return Objects.hash(this.phaseStats, this.indicesManaged);
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            PolicyStats other = (PolicyStats)obj;
            return Objects.equals(this.phaseStats, other.phaseStats) && Objects.equals(this.indicesManaged, other.indicesManaged);
        }

        public String toString() {
            return Strings.toString(this);
        }
    }
}

