/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.repositories;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.ResourceNotFoundException;
import org.elasticsearch.Version;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.UUIDs;
import org.elasticsearch.common.collect.Iterators;
import org.elasticsearch.common.util.CollectionUtils;
import org.elasticsearch.common.util.Maps;
import org.elasticsearch.common.xcontent.XContentParserUtils;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.index.IndexVersion;
import org.elasticsearch.index.IndexVersions;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.repositories.FinalizeSnapshotContext;
import org.elasticsearch.repositories.IndexId;
import org.elasticsearch.repositories.IndexMetaDataGenerations;
import org.elasticsearch.repositories.ShardGeneration;
import org.elasticsearch.repositories.ShardGenerations;
import org.elasticsearch.snapshots.SnapshotId;
import org.elasticsearch.snapshots.SnapshotInfo;
import org.elasticsearch.snapshots.SnapshotState;
import org.elasticsearch.snapshots.SnapshotsService;
import org.elasticsearch.snapshots.SnapshotsServiceUtils;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.xcontent.XContentBuilder;
import org.elasticsearch.xcontent.XContentParser;

public final class RepositoryData {
    public static final long EMPTY_REPO_GEN = -1L;
    public static final long UNKNOWN_REPO_GEN = -2L;
    public static final long CORRUPTED_REPO_GEN = -3L;
    public static final String MISSING_UUID = "_na_";
    public static final RepositoryData EMPTY = new RepositoryData("_na_", -1L, Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), Collections.emptyMap(), ShardGenerations.EMPTY, IndexMetaDataGenerations.EMPTY, "_na_");
    private final String uuid;
    private final String clusterUUID;
    private final long genId;
    private final Map<String, SnapshotId> snapshotIds;
    private final Map<String, SnapshotDetails> snapshotsDetails;
    private final Map<String, IndexId> indices;
    private final Map<IndexId, List<SnapshotId>> indexSnapshots;
    private final IndexMetaDataGenerations indexMetaDataGenerations;
    private final ShardGenerations shardGenerations;
    private static final String SHARD_GENERATIONS = "shard_generations";
    private static final String INDEX_METADATA_IDENTIFIERS = "index_metadata_identifiers";
    private static final String INDEX_METADATA_LOOKUP = "index_metadata_lookup";
    private static final String SNAPSHOTS = "snapshots";
    private static final String INDICES = "indices";
    private static final String INDEX_ID = "id";
    private static final String NAME = "name";
    private static final String UUID = "uuid";
    private static final String CLUSTER_UUID = "cluster_id";
    private static final String STATE = "state";
    private static final String VERSION = "version";
    private static final String INDEX_VERSION = "index_version";
    private static final String MIN_VERSION = "min_version";
    private static final String START_TIME_MILLIS = "start_time_millis";
    private static final String END_TIME_MILLIS = "end_time_millis";
    private static final String SLM_POLICY = "slm_policy";
    private static final IndexVersion NUMERIC_INDEX_VERSION_MARKER = IndexVersion.fromId(8110099);
    private static final String NUMERIC_INDEX_VERSION_MARKER_STRING = "8.11.0";
    private static final Logger logger = LogManager.getLogger(RepositoryData.class);

    public RepositoryData(String uuid, long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotDetails> snapshotsDetails, Map<IndexId, List<SnapshotId>> indexSnapshots, ShardGenerations shardGenerations, IndexMetaDataGenerations indexMetaDataGenerations, String clusterUUID) {
        this(uuid, genId, Collections.unmodifiableMap(snapshotIds), Collections.unmodifiableMap(snapshotsDetails), indexSnapshots.keySet().stream().collect(Collectors.toUnmodifiableMap(IndexId::getName, Function.identity())), Collections.unmodifiableMap(indexSnapshots), shardGenerations, indexMetaDataGenerations, clusterUUID);
    }

    private RepositoryData(String uuid, long genId, Map<String, SnapshotId> snapshotIds, Map<String, SnapshotDetails> snapshotsDetails, Map<String, IndexId> indices, Map<IndexId, List<SnapshotId>> indexSnapshots, ShardGenerations shardGenerations, IndexMetaDataGenerations indexMetaDataGenerations, String clusterUUID) {
        this.uuid = Objects.requireNonNull(uuid);
        this.genId = genId;
        this.snapshotIds = snapshotIds;
        this.snapshotsDetails = snapshotsDetails;
        this.indices = indices;
        this.indexSnapshots = indexSnapshots;
        this.shardGenerations = shardGenerations;
        this.indexMetaDataGenerations = indexMetaDataGenerations;
        this.clusterUUID = Objects.requireNonNull(clusterUUID);
        assert (uuid.equals(MISSING_UUID) == clusterUUID.equals(MISSING_UUID)) : "Either repository- and cluster UUID must both be missing or neither of them must be missing but saw [" + uuid + "][" + clusterUUID + "]";
        assert (indices.values().containsAll(shardGenerations.indices())) : "ShardGenerations contained indices " + String.valueOf(shardGenerations.indices()) + " but snapshots only reference indices " + String.valueOf(indices.values());
        assert (indexSnapshots.values().stream().noneMatch(snapshotIdList -> Set.copyOf(snapshotIdList).size() != snapshotIdList.size())) : "Found duplicate snapshot ids per index in [" + String.valueOf(indexSnapshots) + "]";
    }

    protected RepositoryData copy() {
        return new RepositoryData(this.uuid, this.genId, this.snapshotIds, this.snapshotsDetails, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations, this.clusterUUID);
    }

    public RepositoryData withoutShardGenerations() {
        return new RepositoryData(this.uuid, this.genId, this.snapshotIds, this.snapshotsDetails, this.indices, this.indexSnapshots, ShardGenerations.EMPTY, this.indexMetaDataGenerations, this.clusterUUID);
    }

    public RepositoryData withExtraDetails(Map<SnapshotId, SnapshotDetails> extraDetails) {
        if (extraDetails.isEmpty()) {
            return this;
        }
        HashMap<String, SnapshotDetails> newDetails = new HashMap<String, SnapshotDetails>(this.snapshotsDetails);
        extraDetails.forEach((id, extraDetail) -> newDetails.put(id.getUUID(), (SnapshotDetails)extraDetail));
        return new RepositoryData(this.uuid, this.genId, this.snapshotIds, newDetails, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations, this.clusterUUID);
    }

    public ShardGenerations shardGenerations() {
        return this.shardGenerations;
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getClusterUUID() {
        return this.clusterUUID;
    }

    public long getGenId() {
        return this.genId;
    }

    public Collection<SnapshotId> getSnapshotIds() {
        return this.snapshotIds.values();
    }

    public long getIndexSnapshotCount() {
        return this.indexSnapshots.values().stream().mapToLong(List::size).sum();
    }

    public boolean hasMissingDetails(SnapshotId snapshotId) {
        SnapshotDetails snapshotDetails = this.getSnapshotDetails(snapshotId);
        return snapshotDetails == null || snapshotDetails.getVersion() == null || snapshotDetails.getVersion().id() == NUMERIC_INDEX_VERSION_MARKER.id() || snapshotDetails.getStartTimeMillis() == -1L || snapshotDetails.getEndTimeMillis() == -1L || snapshotDetails.getSlmPolicy() == null;
    }

    @Nullable
    public SnapshotDetails getSnapshotDetails(SnapshotId snapshotId) {
        return this.snapshotsDetails.get(snapshotId.getUUID());
    }

    @Nullable
    public SnapshotState getSnapshotState(SnapshotId snapshotId) {
        return this.snapshotsDetails.getOrDefault(snapshotId.getUUID(), SnapshotDetails.EMPTY).getSnapshotState();
    }

    @Nullable
    public IndexVersion getVersion(SnapshotId snapshotId) {
        return this.snapshotsDetails.getOrDefault(snapshotId.getUUID(), SnapshotDetails.EMPTY).getVersion();
    }

    public Map<String, IndexId> getIndices() {
        return this.indices;
    }

    public Iterator<IndexId> indicesToUpdateAfterRemovingSnapshot(Collection<SnapshotId> snapshotIds) {
        return Iterators.flatMap(this.indexSnapshots.entrySet().iterator(), entry -> {
            if (RepositoryData.isIndexToUpdateAfterRemovingSnapshots((Collection)entry.getValue(), snapshotIds)) {
                return Iterators.single((IndexId)entry.getKey());
            }
            return Collections.emptyIterator();
        });
    }

    private static boolean isIndexToUpdateAfterRemovingSnapshots(Collection<SnapshotId> snapshotsContainingIndex, Collection<SnapshotId> snapshotsToDelete) {
        if (snapshotsToDelete.containsAll(snapshotsContainingIndex)) {
            return snapshotsContainingIndex.size() > snapshotsToDelete.size();
        }
        for (SnapshotId snapshotId : snapshotsToDelete) {
            if (!snapshotsContainingIndex.contains(snapshotId)) continue;
            return true;
        }
        return false;
    }

    public Map<IndexId, Collection<String>> indexMetaDataToRemoveAfterRemovingSnapshots(Collection<SnapshotId> snapshotIds) {
        assert (ThreadPool.assertCurrentThreadPool("snapshot"));
        Iterator<IndexId> indicesForSnapshot = this.indicesToUpdateAfterRemovingSnapshot(snapshotIds);
        Set allRemainingIdentifiers = this.indexMetaDataGenerations.lookup.entrySet().stream().filter(e -> !snapshotIds.contains(e.getKey())).flatMap(e -> ((Map)e.getValue()).values().stream()).map(this.indexMetaDataGenerations::getIndexMetaBlobId).collect(Collectors.toSet());
        HashMap<IndexId, Collection<String>> toRemove = new HashMap<IndexId, Collection<String>>();
        while (indicesForSnapshot.hasNext()) {
            IndexId indexId = indicesForSnapshot.next();
            for (SnapshotId snapshotId : snapshotIds) {
                String identifier = this.indexMetaDataGenerations.indexMetaBlobId(snapshotId, indexId);
                if (allRemainingIdentifiers.contains(identifier)) continue;
                toRemove.computeIfAbsent(indexId, k -> new HashSet()).add(identifier);
            }
        }
        return toRemove;
    }

    public RepositoryData addSnapshot(SnapshotId snapshotId, SnapshotDetails details, FinalizeSnapshotContext.UpdatedShardGenerations updatedShardGenerations, @Nullable Map<IndexId, String> indexMetaBlobs, @Nullable Map<String, String> newIdentifiers) {
        IndexMetaDataGenerations newIndexMetaGenerations;
        if (this.snapshotIds.containsKey(snapshotId.getUUID())) {
            return this;
        }
        Collection<IndexId> liveIndexIds = updatedShardGenerations.liveIndices().indices();
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>(this.snapshotIds);
        snapshots.put(snapshotId.getUUID(), snapshotId);
        HashMap<String, SnapshotDetails> newSnapshotDetails = new HashMap<String, SnapshotDetails>(this.snapshotsDetails);
        newSnapshotDetails.put(snapshotId.getUUID(), details);
        HashMap<IndexId, List<SnapshotId>> allIndexSnapshots = new HashMap<IndexId, List<SnapshotId>>(this.indexSnapshots);
        for (IndexId indexId : liveIndexIds) {
            List snapshotIds = (List)allIndexSnapshots.get(indexId);
            if (snapshotIds == null) {
                allIndexSnapshots.put(indexId, List.of(snapshotId));
                continue;
            }
            allIndexSnapshots.put(indexId, CollectionUtils.appendToCopy(snapshotIds, snapshotId));
        }
        if (indexMetaBlobs == null) {
            assert (newIdentifiers == null) : "Non-null new identifiers [" + String.valueOf(newIdentifiers) + "] for null lookup";
            assert (this.indexMetaDataGenerations.lookup.isEmpty()) : "Index meta generations should have been empty but was [" + String.valueOf(this.indexMetaDataGenerations) + "]";
            newIndexMetaGenerations = IndexMetaDataGenerations.EMPTY;
        } else {
            assert (indexMetaBlobs.isEmpty() || liveIndexIds.equals(indexMetaBlobs.keySet())) : "Shard generations contained indices " + String.valueOf(liveIndexIds) + " but indexMetaData was given for " + String.valueOf(indexMetaBlobs.keySet());
            newIndexMetaGenerations = this.indexMetaDataGenerations.withAddedSnapshot(snapshotId, indexMetaBlobs, newIdentifiers);
        }
        return new RepositoryData(this.uuid, this.genId, snapshots, newSnapshotDetails, allIndexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).update(updatedShardGenerations).build(), newIndexMetaGenerations, this.clusterUUID);
    }

    public RepositoryData withGenId(long newGeneration) {
        if (newGeneration == this.genId) {
            return this;
        }
        return new RepositoryData(this.uuid, newGeneration, this.snapshotIds, this.snapshotsDetails, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations, this.clusterUUID);
    }

    public RepositoryData withoutUUIDs() {
        return new RepositoryData(MISSING_UUID, this.genId, this.snapshotIds, this.snapshotsDetails, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations, MISSING_UUID);
    }

    public RepositoryData withClusterUuid(String clusterUUID) {
        assert (!clusterUUID.equals(MISSING_UUID));
        return new RepositoryData(this.uuid.equals(MISSING_UUID) ? UUIDs.randomBase64UUID() : this.uuid, this.genId, this.snapshotIds, this.snapshotsDetails, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations, clusterUUID);
    }

    public RepositoryData removeSnapshots(Collection<SnapshotId> snapshots, ShardGenerations updatedShardGenerations) {
        Map<String, SnapshotId> newSnapshotIds = this.snapshotIds.values().stream().filter(Predicate.not(snapshots::contains)).collect(Collectors.toMap(SnapshotId::getUUID, Function.identity()));
        if (newSnapshotIds.size() != this.snapshotIds.size() - snapshots.size()) {
            HashSet<SnapshotId> notFound = new HashSet<SnapshotId>(snapshots);
            notFound.removeAll(this.snapshotIds.values());
            throw new ResourceNotFoundException("Attempting to remove non-existent snapshots {} from repository data", notFound);
        }
        HashMap<String, SnapshotDetails> newSnapshotsDetails = new HashMap<String, SnapshotDetails>(this.snapshotsDetails);
        for (SnapshotId snapshotId : snapshots) {
            newSnapshotsDetails.remove(snapshotId.getUUID());
        }
        HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>();
        for (IndexId indexId : this.indices.values()) {
            List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            List<SnapshotId> remaining = new ArrayList<SnapshotId>(snapshotIds);
            remaining = remaining.removeAll(snapshots) ? Collections.unmodifiableList(remaining) : snapshotIds;
            if (remaining.isEmpty()) continue;
            indexSnapshots.put(indexId, remaining);
        }
        return new RepositoryData(this.uuid, this.genId, newSnapshotIds, newSnapshotsDetails, indexSnapshots, ShardGenerations.builder().putAll(this.shardGenerations).putAll(updatedShardGenerations).retainIndicesAndPruneDeletes(indexSnapshots.keySet()).build(), this.indexMetaDataGenerations.withRemovedSnapshots(snapshots), this.clusterUUID);
    }

    public List<SnapshotId> getSnapshots(IndexId indexId) {
        List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
        if (snapshotIds == null) {
            throw new IllegalArgumentException("unknown snapshot index " + String.valueOf(indexId));
        }
        return snapshotIds;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        RepositoryData that = (RepositoryData)obj;
        return this.snapshotIds.equals(that.snapshotIds) && this.snapshotsDetails.equals(that.snapshotsDetails) && this.indices.equals(that.indices) && this.indexSnapshots.equals(that.indexSnapshots) && this.shardGenerations.equals(that.shardGenerations) && this.indexMetaDataGenerations.equals(that.indexMetaDataGenerations);
    }

    public int hashCode() {
        return Objects.hash(this.snapshotIds, this.snapshotsDetails, this.indices, this.indexSnapshots, this.shardGenerations, this.indexMetaDataGenerations);
    }

    public String toString() {
        return Strings.format("RepositoryData[uuid=%s,gen=%s]", this.uuid, this.genId);
    }

    public IndexId resolveIndexId(String indexName) {
        return Objects.requireNonNull(this.indices.get(indexName), () -> "Tried to resolve unknown index [" + indexName + "]");
    }

    public Map<String, IndexId> resolveIndices(List<String> indices) {
        Map<String, IndexId> resolvedIndices = Maps.newMapWithExpectedSize(indices.size());
        for (String indexName : indices) {
            IndexId indexId = this.resolveIndexId(indexName);
            resolvedIndices.put(indexId.getName(), indexId);
        }
        return Collections.unmodifiableMap(resolvedIndices);
    }

    public boolean hasIndex(String indexName) {
        return this.indices.containsKey(indexName);
    }

    public Map<String, IndexId> resolveNewIndices(List<String> indicesToResolve, Map<String, IndexId> inFlightIds) {
        Map<String, IndexId> snapshotIndices = Maps.newMapWithExpectedSize(indicesToResolve.size());
        for (String index : indicesToResolve) {
            IndexId indexId = this.indices.get(index);
            if (indexId == null) {
                indexId = inFlightIds.get(index);
            }
            if (indexId == null) {
                indexId = new IndexId(index, UUIDs.randomBase64UUID());
            }
            snapshotIndices.put(indexId.getName(), indexId);
        }
        return Map.copyOf(snapshotIndices);
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, IndexVersion repoMetaVersion) throws IOException {
        return this.snapshotsToXContent(builder, repoMetaVersion, false);
    }

    public XContentBuilder snapshotsToXContent(XContentBuilder builder, IndexVersion repoMetaVersion, boolean permitMissingUuid) throws IOException {
        boolean shouldWriteUUIDS = SnapshotsServiceUtils.includesUUIDs(repoMetaVersion);
        boolean shouldWriteIndexGens = SnapshotsServiceUtils.useIndexGenerations(repoMetaVersion);
        boolean shouldWriteShardGens = SnapshotsServiceUtils.useShardGenerations(repoMetaVersion);
        assert (Boolean.compare(shouldWriteUUIDS, shouldWriteIndexGens) <= 0);
        assert (Boolean.compare(shouldWriteIndexGens, shouldWriteShardGens) <= 0);
        builder.startObject();
        if (shouldWriteShardGens) {
            IndexVersion minVersion = shouldWriteUUIDS ? SnapshotsService.UUIDS_IN_REPO_DATA_VERSION : (shouldWriteIndexGens ? SnapshotsService.INDEX_GEN_IN_REPO_DATA_VERSION : SnapshotsService.SHARD_GEN_IN_REPO_DATA_VERSION);
            if (minVersion.before(IndexVersions.V_8_10_0)) {
                builder.field(MIN_VERSION, Version.fromId(minVersion.id()).toString());
            } else {
                assert (false) : "writing a numeric version [" + String.valueOf(minVersion) + "] is unhelpful here, see preceding comment";
                builder.field(MIN_VERSION, minVersion.id());
            }
        }
        if (shouldWriteUUIDS) {
            if (this.uuid.equals(MISSING_UUID)) {
                if (!permitMissingUuid) {
                    assert (false) : "missing uuid";
                    throw new IllegalStateException("missing uuid");
                }
            } else {
                builder.field(UUID, this.uuid);
            }
            if (this.clusterUUID.equals(MISSING_UUID)) {
                if (!permitMissingUuid) {
                    assert (false) : "missing clusterUUID";
                    throw new IllegalStateException("missing clusterUUID");
                }
            } else {
                builder.field(CLUSTER_UUID, this.clusterUUID);
            }
        } else {
            IllegalStateException e;
            if (!this.uuid.equals(MISSING_UUID)) {
                e = new IllegalStateException("lost uuid + [" + this.uuid + "]");
                assert (false) : e;
                throw e;
            }
            if (!this.clusterUUID.equals(MISSING_UUID)) {
                e = new IllegalStateException("lost clusterUUID + [" + this.uuid + "]");
                assert (false) : e;
                throw e;
            }
        }
        int numericIndexVersionMarkerPlaceholdersUsed = 0;
        SnapshotId lastSnapshotWithNumericIndexVersionPlaceholder = null;
        builder.startArray(SNAPSHOTS);
        for (SnapshotId snapshot : this.getSnapshotIds()) {
            IndexVersion version;
            builder.startObject();
            builder.field(NAME, snapshot.getName());
            String snapshotUUID = snapshot.getUUID();
            builder.field(UUID, snapshotUUID);
            SnapshotDetails snapshotDetails = this.snapshotsDetails.getOrDefault(snapshotUUID, SnapshotDetails.EMPTY);
            SnapshotState state = snapshotDetails.getSnapshotState();
            if (state != null) {
                builder.field(STATE, state.value());
            }
            if (shouldWriteIndexGens) {
                builder.startObject(INDEX_METADATA_LOOKUP);
                for (Map.Entry entry : this.indexMetaDataGenerations.lookup.getOrDefault(snapshot, Collections.emptyMap()).entrySet()) {
                    builder.field(((IndexId)entry.getKey()).getId(), (String)entry.getValue());
                }
                builder.endObject();
            }
            if ((version = snapshotDetails.getVersion()) != null) {
                if (version.equals(NUMERIC_INDEX_VERSION_MARKER)) {
                    ++numericIndexVersionMarkerPlaceholdersUsed;
                    lastSnapshotWithNumericIndexVersionPlaceholder = snapshot;
                    builder.field(VERSION, NUMERIC_INDEX_VERSION_MARKER_STRING);
                } else if (version.onOrAfter(IndexVersions.FIRST_DETACHED_INDEX_VERSION)) {
                    builder.field(VERSION, NUMERIC_INDEX_VERSION_MARKER_STRING);
                    builder.field(INDEX_VERSION, version.id());
                } else {
                    assert (version.id() < NUMERIC_INDEX_VERSION_MARKER.id()) : version;
                    builder.field(VERSION, Version.fromId(version.id()).toString());
                }
            }
            if (snapshotDetails.getStartTimeMillis() != -1L) {
                builder.field(START_TIME_MILLIS, snapshotDetails.getStartTimeMillis());
            }
            if (snapshotDetails.getEndTimeMillis() != -1L) {
                builder.field(END_TIME_MILLIS, snapshotDetails.getEndTimeMillis());
            }
            if (snapshotDetails.getSlmPolicy() != null) {
                builder.field(SLM_POLICY, snapshotDetails.getSlmPolicy());
            }
            builder.endObject();
        }
        builder.endArray();
        if (numericIndexVersionMarkerPlaceholdersUsed > 0) {
            logger.warn("created RepositoryData with [{}] snapshot(s) using a placeholder version of '8.11.0', including [{}]", numericIndexVersionMarkerPlaceholdersUsed, lastSnapshotWithNumericIndexVersionPlaceholder);
        }
        builder.startObject(INDICES);
        for (IndexId indexId : this.getIndices().values()) {
            builder.startObject(indexId.getName());
            builder.field(INDEX_ID, indexId.getId());
            builder.startArray(SNAPSHOTS);
            List<SnapshotId> snapshotIds = this.indexSnapshots.get(indexId);
            assert (snapshotIds != null);
            for (SnapshotId snapshotId : snapshotIds) {
                builder.value(snapshotId.getUUID());
            }
            builder.endArray();
            if (shouldWriteShardGens) {
                builder.xContentList(SHARD_GENERATIONS, this.shardGenerations.getGens(indexId));
            }
            builder.endObject();
        }
        builder.endObject();
        if (shouldWriteIndexGens) {
            builder.field(INDEX_METADATA_IDENTIFIERS, this.indexMetaDataGenerations.identifiers);
        }
        builder.endObject();
        return builder;
    }

    public IndexMetaDataGenerations indexMetaDataGenerations() {
        return this.indexMetaDataGenerations;
    }

    public static RepositoryData snapshotsFromXContent(XContentParser parser, long genId, boolean fixBrokenShardGens) throws IOException {
        String field;
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        HashMap<String, SnapshotId> snapshots = new HashMap<String, SnapshotId>();
        HashMap<String, SnapshotDetails> snapshotsDetails = new HashMap<String, SnapshotDetails>();
        HashMap<IndexId, List<SnapshotId>> indexSnapshots = new HashMap<IndexId, List<SnapshotId>>();
        HashMap<String, IndexId> indexLookup = new HashMap<String, IndexId>();
        ShardGenerations.Builder shardGenerations = ShardGenerations.builder();
        HashMap<SnapshotId, Map<String, String>> indexMetaLookup = new HashMap<SnapshotId, Map<String, String>>();
        Map<String, String> indexMetaIdentifiers = null;
        String uuid = MISSING_UUID;
        String clusterUUID = MISSING_UUID;
        block26: while ((field = parser.nextFieldName()) != null) {
            switch (field) {
                case "snapshots": {
                    RepositoryData.parseSnapshots(parser, snapshots, snapshotsDetails, indexMetaLookup);
                    break;
                }
                case "indices": {
                    RepositoryData.parseIndices(parser, fixBrokenShardGens, snapshots, indexSnapshots, indexLookup, shardGenerations);
                    break;
                }
                case "index_metadata_identifiers": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
                    indexMetaIdentifiers = parser.mapStrings();
                    break;
                }
                case "min_version": {
                    String versionString;
                    XContentParser.Token token = parser.nextToken();
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, token, parser);
                    IndexVersion version = switch (versionString = parser.text()) {
                        case "7.12.0" -> IndexVersions.V_7_12_0;
                        case "7.9.0" -> IndexVersions.V_7_9_0;
                        case "7.6.0" -> IndexVersions.V_7_6_0;
                        default -> throw new IllegalStateException(Strings.format("this snapshot repository format requires Elasticsearch version [%s] or later", versionString));
                    };
                    assert (SnapshotsServiceUtils.useShardGenerations(version));
                    continue block26;
                }
                case "uuid": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, parser.nextToken(), parser);
                    uuid = parser.text();
                    assert (!uuid.equals(MISSING_UUID));
                    continue block26;
                }
                case "cluster_id": {
                    XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, parser.nextToken(), parser);
                    clusterUUID = parser.text();
                    assert (!clusterUUID.equals(MISSING_UUID));
                    continue block26;
                }
                default: {
                    XContentParserUtils.throwUnknownField(field, parser);
                }
            }
        }
        XContentParserUtils.ensureExpectedToken(null, parser.nextToken(), parser);
        return new RepositoryData(uuid, genId, snapshots, snapshotsDetails, indexSnapshots, shardGenerations.build(), RepositoryData.buildIndexMetaGenerations(indexMetaLookup, indexLookup, indexMetaIdentifiers), clusterUUID);
    }

    private static IndexMetaDataGenerations buildIndexMetaGenerations(Map<SnapshotId, Map<String, String>> indexMetaLookup, Map<String, IndexId> indexLookup, Map<String, String> indexMetaIdentifiers) {
        if (indexMetaLookup.isEmpty()) {
            return IndexMetaDataGenerations.EMPTY;
        }
        Map<SnapshotId, Map<IndexId, String>> indexGenerations = Maps.newMapWithExpectedSize(indexMetaLookup.size());
        for (Map.Entry<SnapshotId, Map<String, String>> snapshotIdMapEntry : indexMetaLookup.entrySet()) {
            Map<String, String> val = snapshotIdMapEntry.getValue();
            Map<IndexId, String> forSnapshot = Maps.newMapWithExpectedSize(val.size());
            for (Map.Entry<String, String> generationEntry : val.entrySet()) {
                forSnapshot.put(indexLookup.get(generationEntry.getKey()), generationEntry.getValue());
            }
            indexGenerations.put(snapshotIdMapEntry.getKey(), Map.copyOf(forSnapshot));
        }
        return new IndexMetaDataGenerations(indexGenerations, indexMetaIdentifiers);
    }

    private static void parseSnapshots(XContentParser parser, Map<String, SnapshotId> snapshots, Map<String, SnapshotDetails> snapshotsDetails, Map<SnapshotId, Map<String, String>> indexMetaLookup) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, parser.nextToken(), parser);
        HashMap stringDeduplicator = new HashMap();
        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
            String name = null;
            String uuid = null;
            SnapshotState state = null;
            Map<String, String> metaGenerations = null;
            IndexVersion version = null;
            IndexVersion indexVersion = null;
            long startTimeMillis = -1L;
            long endTimeMillis = -1L;
            String slmPolicy = null;
            while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String currentFieldName = parser.currentName();
                XContentParser.Token token = parser.nextToken();
                switch (currentFieldName) {
                    case "name": {
                        name = parser.text();
                        break;
                    }
                    case "uuid": {
                        uuid = parser.text();
                        break;
                    }
                    case "state": {
                        state = SnapshotState.fromValue((byte)parser.intValue());
                        break;
                    }
                    case "index_metadata_lookup": {
                        metaGenerations = parser.map(HashMap::new, p -> (String)stringDeduplicator.computeIfAbsent(p.text(), Function.identity()));
                        break;
                    }
                    case "version": {
                        version = RepositoryData.parseIndexVersion(token, parser);
                        break;
                    }
                    case "index_version": {
                        indexVersion = IndexVersion.fromId(parser.intValue());
                        break;
                    }
                    case "start_time_millis": {
                        assert (startTimeMillis == -1L);
                        startTimeMillis = parser.longValue();
                        break;
                    }
                    case "end_time_millis": {
                        assert (endTimeMillis == -1L);
                        endTimeMillis = parser.longValue();
                        break;
                    }
                    case "slm_policy": {
                        slmPolicy = (String)stringDeduplicator.computeIfAbsent(parser.text(), Function.identity());
                    }
                }
            }
            assert (startTimeMillis == -1L == (endTimeMillis == -1L)) : "unexpected: " + startTimeMillis + ", " + endTimeMillis + ", ";
            SnapshotId snapshotId = new SnapshotId(name, uuid);
            if (indexVersion != null) {
                version = indexVersion;
            }
            if (state != null || version != null) {
                snapshotsDetails.put(uuid, new SnapshotDetails(state, version, startTimeMillis, endTimeMillis, slmPolicy));
            }
            snapshots.put(uuid, snapshotId);
            if (metaGenerations == null || metaGenerations.isEmpty()) continue;
            indexMetaLookup.put(snapshotId, metaGenerations);
        }
    }

    private static IndexVersion parseIndexVersion(XContentParser.Token token, XContentParser parser) throws IOException {
        if (token == XContentParser.Token.VALUE_NUMBER) {
            return IndexVersion.fromId(parser.intValue());
        }
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.VALUE_STRING, token, parser);
        String versionStr = parser.text();
        if (NUMERIC_INDEX_VERSION_MARKER_STRING.equals(versionStr)) {
            return NUMERIC_INDEX_VERSION_MARKER;
        }
        int versionId = Version.fromString((String)versionStr).id;
        if (versionId > 8110099 && versionId < 8500000) {
            logger.error("found impossible string index version [{}] with id [{}]", versionStr, versionId);
        }
        return IndexVersion.fromId(versionId);
    }

    private static void parseIndices(XContentParser parser, boolean fixBrokenShardGens, Map<String, SnapshotId> snapshots, Map<IndexId, List<SnapshotId>> indexSnapshots, Map<String, IndexId> indexLookup, ShardGenerations.Builder shardGenerations) throws IOException {
        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String indexName = parser.currentName();
            ArrayList<SnapshotId> snapshotIds = new ArrayList<SnapshotId>();
            ArrayList<ShardGeneration> gens = new ArrayList<ShardGeneration>();
            IndexId indexId = null;
            XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_OBJECT, parser.nextToken(), parser);
            block11: while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
                String indexMetaFieldName = parser.currentName();
                XContentParser.Token currentToken = parser.nextToken();
                switch (indexMetaFieldName) {
                    case "id": {
                        indexId = new IndexId(indexName, parser.text());
                        break;
                    }
                    case "snapshots": {
                        XContentParser.Token currToken;
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, currentToken, parser);
                        while ((currToken = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                            String uuid = currToken == XContentParser.Token.START_OBJECT ? RepositoryData.parseLegacySnapshotUUID(parser) : parser.text();
                            SnapshotId snapshotId = snapshots.get(uuid);
                            if (snapshotId == null) {
                                throw new ElasticsearchParseException("Detected a corrupted repository, index " + String.valueOf(indexId) + " references an unknown snapshot uuid [" + uuid + "]", new Object[0]);
                            }
                            snapshotIds.add(snapshotId);
                        }
                        continue block11;
                    }
                    case "shard_generations": {
                        XContentParserUtils.ensureExpectedToken(XContentParser.Token.START_ARRAY, currentToken, parser);
                        while (parser.nextToken() != XContentParser.Token.END_ARRAY) {
                            gens.add(ShardGeneration.fromXContent(parser));
                        }
                        break;
                    }
                }
            }
            assert (indexId != null);
            indexSnapshots.put(indexId, Collections.unmodifiableList(snapshotIds));
            indexLookup.put(indexId.getId(), indexId);
            for (int i = 0; i < gens.size(); ++i) {
                ShardGeneration parsedGen = (ShardGeneration)gens.get(i);
                if (fixBrokenShardGens) {
                    parsedGen = ShardGenerations.fixShardGeneration(parsedGen);
                }
                if (parsedGen == null) continue;
                shardGenerations.put(indexId, i, parsedGen);
            }
        }
    }

    private static String parseLegacySnapshotUUID(XContentParser parser) throws IOException {
        String uuid = null;
        while (parser.nextToken() != XContentParser.Token.END_OBJECT) {
            String currentFieldName = parser.currentName();
            parser.nextToken();
            if (!UUID.equals(currentFieldName)) continue;
            uuid = parser.text();
        }
        return uuid;
    }

    public static class SnapshotDetails {
        public static final SnapshotDetails EMPTY = new SnapshotDetails(null, null, -1L, -1L, null);
        @Nullable
        private final SnapshotState snapshotState;
        @Nullable
        private final IndexVersion version;
        private final long startTimeMillis;
        private final long endTimeMillis;
        @Nullable
        private final String slmPolicy;

        public SnapshotDetails(@Nullable SnapshotState snapshotState, @Nullable IndexVersion version, long startTimeMillis, long endTimeMillis, @Nullable String slmPolicy) {
            this.snapshotState = snapshotState;
            this.version = version;
            this.startTimeMillis = startTimeMillis;
            this.endTimeMillis = endTimeMillis;
            this.slmPolicy = slmPolicy;
        }

        @Nullable
        public SnapshotState getSnapshotState() {
            return this.snapshotState;
        }

        @Nullable
        public IndexVersion getVersion() {
            return this.version;
        }

        public long getStartTimeMillis() {
            return this.startTimeMillis;
        }

        public long getEndTimeMillis() {
            return this.endTimeMillis;
        }

        @Nullable
        public String getSlmPolicy() {
            return this.slmPolicy;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SnapshotDetails that = (SnapshotDetails)o;
            return this.startTimeMillis == that.startTimeMillis && this.endTimeMillis == that.endTimeMillis && this.snapshotState == that.snapshotState && Objects.equals(this.version, that.version) && Objects.equals(this.slmPolicy, that.slmPolicy);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.snapshotState, this.version, this.startTimeMillis, this.endTimeMillis, this.slmPolicy});
        }

        public String toString() {
            return "SnapshotDetails{snapshotState=" + String.valueOf((Object)this.snapshotState) + ", version=" + String.valueOf(this.version) + ", startTimeMillis=" + this.startTimeMillis + ", endTimeMillis=" + this.endTimeMillis + ", slmPolicy='" + this.slmPolicy + "'}";
        }

        public static SnapshotDetails fromSnapshotInfo(SnapshotInfo snapshotInfo) {
            return new SnapshotDetails(snapshotInfo.state(), snapshotInfo.version(), snapshotInfo.startTime(), snapshotInfo.endTime(), SnapshotDetails.slmPolicy(snapshotInfo.userMetadata()));
        }

        private static String slmPolicy(Map<String, Object> userMetadata) {
            Object object;
            if (userMetadata != null && (object = userMetadata.get("policy")) instanceof String) {
                String policyId = (String)object;
                return policyId;
            }
            return "";
        }
    }
}

