/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.plugins.scanners;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.elasticsearch.logging.LogManager;
import org.elasticsearch.logging.Logger;
import org.elasticsearch.xcontent.XContentParser;
import org.elasticsearch.xcontent.XContentParserConfiguration;
import org.elasticsearch.xcontent.XContentType;

public class ExtensibleFileReader {
    private static final Logger logger = LogManager.getLogger(ExtensibleFileReader.class);
    private String extensibleFile;

    public ExtensibleFileReader(String extensibleFile) {
        this.extensibleFile = extensibleFile;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public Map<String, String> readFromFile() {
        HashMap<String, String> res;
        block14: {
            res = new HashMap<String, String>();
            try (InputStream in = this.getClass().getResourceAsStream(this.extensibleFile);){
                Map<String, String> map;
                block15: {
                    if (in == null) break block14;
                    XContentParser parser = XContentType.JSON.xContent().createParser(XContentParserConfiguration.EMPTY, in);
                    try {
                        map = parser.mapStrings();
                        if (parser == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    parser.close();
                }
                return map;
            }
            catch (IOException e) {
                logger.error("failed reading extensible file", (Throwable)e);
            }
        }
        return res;
    }
}

