/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.engine;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.ToLongFunction;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.RelativeByteSizeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.core.Nullable;
import org.elasticsearch.core.Releasable;
import org.elasticsearch.core.TimeValue;
import org.elasticsearch.core.Tuple;
import org.elasticsearch.env.NodeEnvironment;
import org.elasticsearch.index.engine.MergeEventListener;
import org.elasticsearch.index.engine.ThreadPoolMergeScheduler;
import org.elasticsearch.monitor.fs.FsInfo;
import org.elasticsearch.monitor.fs.FsProbe;
import org.elasticsearch.threadpool.Scheduler;
import org.elasticsearch.threadpool.ThreadPool;

public class ThreadPoolMergeExecutorService
implements Closeable {
    public static final Setting<TimeValue> INDICES_MERGE_DISK_CHECK_INTERVAL_SETTING = Setting.positiveTimeSetting("indices.merge.disk.check_interval", TimeValue.timeValueSeconds(5L), Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<RelativeByteSizeValue> INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING = new Setting<RelativeByteSizeValue>("indices.merge.disk.watermark.high", DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_WATERMARK_SETTING, s -> RelativeByteSizeValue.parseRelativeByteSizeValue(s, "indices.merge.disk.watermark.high"), new Setting.Validator<RelativeByteSizeValue>(){

        @Override
        public void validate(RelativeByteSizeValue value) {
        }

        @Override
        public void validate(RelativeByteSizeValue value, Map<Setting<?>, Object> settings, boolean isPresent) {
            if (isPresent && settings.get(ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING).equals(Boolean.FALSE)) {
                throw new IllegalArgumentException("indices merge watermark setting is only effective when [" + ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING.getKey() + "] is set to [true]");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Boolean>> res = List.of(INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING, ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING);
            return res.iterator();
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    public static final Setting<ByteSizeValue> INDICES_MERGE_DISK_HIGH_MAX_HEADROOM_SETTING = new Setting<ByteSizeValue>("indices.merge.disk.watermark.high.max_headroom", settings -> {
        if (INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING.exists((Settings)settings)) {
            return "-1";
        }
        return DiskThresholdSettings.CLUSTER_ROUTING_ALLOCATION_DISK_FLOOD_STAGE_MAX_HEADROOM_SETTING.get((Settings)settings).toString();
    }, s -> ByteSizeValue.parseBytesSizeValue(s, "indices.merge.disk.watermark.high.max_headroom"), new Setting.Validator<ByteSizeValue>(){

        @Override
        public void validate(ByteSizeValue value) {
        }

        @Override
        public void validate(ByteSizeValue value, Map<Setting<?>, Object> settings, boolean isPresent) {
            if (isPresent) {
                if (value.equals(ByteSizeValue.MINUS_ONE)) {
                    throw new IllegalArgumentException("setting a headroom value to less than 0 is not supported, use [null] value to unset");
                }
                if (settings.get(ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING).equals(Boolean.FALSE)) {
                    throw new IllegalArgumentException("indices merge max headroom setting is only effective when [" + ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING.getKey() + "] is set to [true]");
                }
            }
            RelativeByteSizeValue highWatermark = (RelativeByteSizeValue)settings.get(INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING);
            ByteSizeValue highHeadroom = (ByteSizeValue)settings.get(INDICES_MERGE_DISK_HIGH_MAX_HEADROOM_SETTING);
            if (highWatermark.isAbsolute() && !highHeadroom.equals(ByteSizeValue.MINUS_ONE)) {
                throw new IllegalArgumentException("indices merge max headroom setting is set, but indices merge disk watermark value is not a relative value [" + highWatermark.getStringRep() + "]");
            }
        }

        @Override
        public Iterator<Setting<?>> settings() {
            List<Setting<Boolean>> res = List.of(INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING, INDICES_MERGE_DISK_HIGH_MAX_HEADROOM_SETTING, ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING);
            return res.iterator();
        }
    }, Setting.Property.Dynamic, Setting.Property.NodeScope);
    static final ByteSizeValue MIN_IO_RATE = ByteSizeValue.ofMb(5L);
    static final ByteSizeValue MAX_IO_RATE = ByteSizeValue.ofMb(10240L);
    static final ByteSizeValue START_IO_RATE = ByteSizeValue.ofMb(20L);
    private final AtomicInteger ioThrottledMergeTasksCount = new AtomicInteger();
    private final MergeTaskPriorityBlockingQueue queuedMergeTasks = new MergeTaskPriorityBlockingQueue();
    private final Set<ThreadPoolMergeScheduler.MergeTask> runningMergeTasks = ConcurrentCollections.newConcurrentSet();
    private final AtomicIORate targetIORateBytesPerSec = new AtomicIORate(START_IO_RATE.getBytes());
    private final ExecutorService executorService;
    private final int maxConcurrentMerges;
    private final int concurrentMergesFloorLimitForThrottling;
    private final int concurrentMergesCeilLimitForThrottling;
    private final AvailableDiskSpacePeriodicMonitor availableDiskSpacePeriodicMonitor;
    private final List<MergeEventListener> mergeEventListeners = new CopyOnWriteArrayList<MergeEventListener>();

    @Nullable
    public static ThreadPoolMergeExecutorService maybeCreateThreadPoolMergeExecutorService(ThreadPool threadPool, ClusterSettings clusterSettings, NodeEnvironment nodeEnvironment) {
        if (clusterSettings.get(ThreadPoolMergeScheduler.USE_THREAD_POOL_MERGE_SCHEDULER_SETTING).booleanValue()) {
            return new ThreadPoolMergeExecutorService(threadPool, clusterSettings, nodeEnvironment);
        }
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING, ignored -> {});
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGE_DISK_HIGH_MAX_HEADROOM_SETTING, ignored -> {});
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGE_DISK_CHECK_INTERVAL_SETTING, ignored -> {});
        return null;
    }

    private ThreadPoolMergeExecutorService(ThreadPool threadPool, ClusterSettings clusterSettings, NodeEnvironment nodeEnvironment) {
        this.executorService = threadPool.executor("merge");
        this.maxConcurrentMerges = threadPool.info("merge").getMax();
        this.concurrentMergesFloorLimitForThrottling = 2;
        this.concurrentMergesCeilLimitForThrottling = this.maxConcurrentMerges * 2;
        assert (this.concurrentMergesFloorLimitForThrottling <= this.concurrentMergesCeilLimitForThrottling);
        this.availableDiskSpacePeriodicMonitor = ThreadPoolMergeExecutorService.startDiskSpaceMonitoring(threadPool, nodeEnvironment.dataPaths(), clusterSettings, availableDiskSpaceByteSize -> this.queuedMergeTasks.updateBudget(availableDiskSpaceByteSize.getBytes()));
    }

    boolean submitMergeTask(ThreadPoolMergeScheduler.MergeTask mergeTask) {
        assert (!mergeTask.hasStartedRunning());
        if (!this.enqueueMergeTaskExecution()) {
            mergeTask.abort();
            return false;
        }
        if (mergeTask.supportsIOThrottling()) {
            int currentTaskCount = this.ioThrottledMergeTasksCount.incrementAndGet();
            this.targetIORateBytesPerSec.update(currentTargetIORateBytesPerSec -> ThreadPoolMergeExecutorService.newTargetIORateBytesPerSec(currentTargetIORateBytesPerSec, currentTaskCount, this.concurrentMergesFloorLimitForThrottling, this.concurrentMergesCeilLimitForThrottling), (prevTargetIORateBytesPerSec, newTargetIORateBytesPerSec) -> {
                if (prevTargetIORateBytesPerSec != newTargetIORateBytesPerSec) {
                    this.runningMergeTasks.forEach(runningMergeTask -> {
                        if (runningMergeTask.supportsIOThrottling()) {
                            runningMergeTask.setIORateLimit(newTargetIORateBytesPerSec);
                        }
                    });
                }
            });
        }
        this.enqueueMergeTask(mergeTask);
        return true;
    }

    void reEnqueueBackloggedMergeTask(ThreadPoolMergeScheduler.MergeTask mergeTask) {
        assert (!mergeTask.hasStartedRunning());
        this.enqueueMergeTask(mergeTask);
    }

    private void enqueueMergeTask(ThreadPoolMergeScheduler.MergeTask mergeTask) {
        this.mergeEventListeners.forEach(l -> l.onMergeQueued(mergeTask.getOnGoingMerge(), mergeTask.getMergeMemoryEstimateBytes()));
        boolean added = this.queuedMergeTasks.enqueue(mergeTask);
        assert (added);
    }

    public boolean allDone() {
        return this.queuedMergeTasks.isQueueEmpty() && this.runningMergeTasks.isEmpty() && (long)this.ioThrottledMergeTasksCount.get() == 0L;
    }

    public boolean isMergingBlockedDueToInsufficientDiskSpace() {
        return this.availableDiskSpacePeriodicMonitor.isScheduled() && this.queuedMergeTasks.queueHeadIsOverTheAvailableBudget();
    }

    private boolean enqueueMergeTaskExecution() {
        try {
            this.executorService.execute(() -> {
                while (true) {
                    PriorityBlockingQueueWithBudget.ElementWithReleasableBudget smallestMergeTaskWithReleasableBudget;
                    try {
                        smallestMergeTaskWithReleasableBudget = this.queuedMergeTasks.take();
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    PriorityBlockingQueueWithBudget.ElementWithReleasableBudget ignored = smallestMergeTaskWithReleasableBudget;
                    try {
                        ThreadPoolMergeScheduler.MergeTask smallestMergeTask = (ThreadPoolMergeScheduler.MergeTask)smallestMergeTaskWithReleasableBudget.element();
                        ThreadPoolMergeScheduler.Schedule schedule = smallestMergeTask.schedule();
                        if (schedule == ThreadPoolMergeScheduler.Schedule.RUN) {
                            this.runMergeTask(smallestMergeTask);
                            break;
                        }
                        if (schedule == ThreadPoolMergeScheduler.Schedule.ABORT) {
                            this.abortMergeTask(smallestMergeTask);
                            break;
                        }
                        assert (schedule == ThreadPoolMergeScheduler.Schedule.BACKLOG);
                        continue;
                    }
                    finally {
                        if (ignored == null) continue;
                        ignored.close();
                        continue;
                    }
                    break;
                }
            });
            return true;
        }
        catch (Throwable t) {
            assert (t instanceof RejectedExecutionException);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runMergeTask(ThreadPoolMergeScheduler.MergeTask mergeTask) {
        assert (!mergeTask.hasStartedRunning());
        boolean added = this.runningMergeTasks.add(mergeTask);
        assert (added) : "starting merge task [" + String.valueOf(mergeTask) + "] registered as already running";
        try {
            if (mergeTask.supportsIOThrottling()) {
                mergeTask.setIORateLimit(this.targetIORateBytesPerSec.get());
            }
            mergeTask.run();
        }
        finally {
            boolean removed = this.runningMergeTasks.remove(mergeTask);
            assert (removed) : "completed merge task [" + String.valueOf(mergeTask) + "] not registered as running";
            if (mergeTask.supportsIOThrottling()) {
                this.ioThrottledMergeTasksCount.decrementAndGet();
            }
            this.mergeEventListeners.forEach(l -> l.onMergeCompleted(mergeTask.getOnGoingMerge()));
        }
    }

    void abortMergeTask(ThreadPoolMergeScheduler.MergeTask mergeTask) {
        assert (!mergeTask.hasStartedRunning());
        assert (!this.runningMergeTasks.contains(mergeTask));
        try {
            mergeTask.abort();
        }
        finally {
            if (mergeTask.supportsIOThrottling()) {
                this.ioThrottledMergeTasksCount.decrementAndGet();
            }
            this.mergeEventListeners.forEach(l -> l.onMergeAborted(mergeTask.getOnGoingMerge()));
        }
    }

    private void abortMergeTasks(Collection<ThreadPoolMergeScheduler.MergeTask> mergeTasks) {
        if (mergeTasks != null && !mergeTasks.isEmpty()) {
            for (ThreadPoolMergeScheduler.MergeTask mergeTask : mergeTasks) {
                this.abortMergeTask(mergeTask);
            }
        }
    }

    void abortQueuedMergeTasks(Predicate<ThreadPoolMergeScheduler.MergeTask> predicate) {
        HashSet<ThreadPoolMergeScheduler.MergeTask> queuedMergesToAbort = new HashSet<ThreadPoolMergeScheduler.MergeTask>();
        if (this.queuedMergeTasks.drainMatchingElementsTo(predicate, queuedMergesToAbort) > 0) {
            this.abortMergeTasks(queuedMergesToAbort);
        }
    }

    static AvailableDiskSpacePeriodicMonitor startDiskSpaceMonitoring(ThreadPool threadPool, NodeEnvironment.DataPath[] dataPaths, ClusterSettings clusterSettings, Consumer<ByteSizeValue> availableDiskSpaceUpdateConsumer) {
        AvailableDiskSpacePeriodicMonitor availableDiskSpacePeriodicMonitor = new AvailableDiskSpacePeriodicMonitor(dataPaths, threadPool, clusterSettings.get(INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING), clusterSettings.get(INDICES_MERGE_DISK_HIGH_MAX_HEADROOM_SETTING), clusterSettings.get(INDICES_MERGE_DISK_CHECK_INTERVAL_SETTING), availableDiskSpaceByteSize -> {
            if (availableDiskSpaceByteSize.equals(ByteSizeValue.MINUS_ONE)) {
                availableDiskSpaceUpdateConsumer.accept(ByteSizeValue.ofBytes(Long.MAX_VALUE));
            } else {
                availableDiskSpaceUpdateConsumer.accept((ByteSizeValue)availableDiskSpaceByteSize);
            }
        });
        if (!availableDiskSpacePeriodicMonitor.isScheduled()) {
            availableDiskSpaceUpdateConsumer.accept(ByteSizeValue.ofBytes(Long.MAX_VALUE));
        }
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGE_DISK_HIGH_WATERMARK_SETTING, availableDiskSpacePeriodicMonitor::setHighStageWatermark);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGE_DISK_HIGH_MAX_HEADROOM_SETTING, availableDiskSpacePeriodicMonitor::setHighStageMaxHeadroom);
        clusterSettings.addSettingsUpdateConsumer(INDICES_MERGE_DISK_CHECK_INTERVAL_SETTING, availableDiskSpacePeriodicMonitor::setCheckInterval);
        return availableDiskSpacePeriodicMonitor;
    }

    private static long newTargetIORateBytesPerSec(long currentTargetIORateBytesPerSec, int currentlySubmittedIOThrottledMergeTasks, int concurrentMergesFloorLimitForThrottling, int concurrentMergesCeilLimitForThrottling) {
        long newTargetIORateBytesPerSec = currentlySubmittedIOThrottledMergeTasks < concurrentMergesFloorLimitForThrottling && currentTargetIORateBytesPerSec > MIN_IO_RATE.getBytes() ? Math.max(MIN_IO_RATE.getBytes(), currentTargetIORateBytesPerSec - currentTargetIORateBytesPerSec / 10L) : (currentlySubmittedIOThrottledMergeTasks > concurrentMergesCeilLimitForThrottling && currentTargetIORateBytesPerSec < MAX_IO_RATE.getBytes() ? Math.min(MAX_IO_RATE.getBytes(), currentTargetIORateBytesPerSec + currentTargetIORateBytesPerSec / 5L) : currentTargetIORateBytesPerSec);
        return newTargetIORateBytesPerSec;
    }

    public boolean usingMaxTargetIORateBytesPerSec() {
        return MAX_IO_RATE.getBytes() == this.targetIORateBytesPerSec.get();
    }

    public void registerMergeEventListener(MergeEventListener consumer) {
        this.mergeEventListeners.add(consumer);
    }

    Set<ThreadPoolMergeScheduler.MergeTask> getRunningMergeTasks() {
        return this.runningMergeTasks;
    }

    int getMergeTasksQueueLength() {
        return this.queuedMergeTasks.queueSize();
    }

    long getDiskSpaceAvailableForNewMergeTasks() {
        return this.queuedMergeTasks.getAvailableBudget();
    }

    long getTargetIORateBytesPerSec() {
        return this.targetIORateBytesPerSec.get();
    }

    int getMaxConcurrentMerges() {
        return this.maxConcurrentMerges;
    }

    @Override
    public void close() throws IOException {
        this.availableDiskSpacePeriodicMonitor.close();
    }

    static class MergeTaskPriorityBlockingQueue
    extends PriorityBlockingQueueWithBudget<ThreadPoolMergeScheduler.MergeTask> {
        private static final Logger LOGGER = LogManager.getLogger(MergeTaskPriorityBlockingQueue.class);

        MergeTaskPriorityBlockingQueue() {
            super(ThreadPoolMergeScheduler.MergeTask::estimatedRemainingMergeSize, 0L);
        }

        long getAvailableBudget() {
            return this.availableBudget;
        }

        ThreadPoolMergeScheduler.MergeTask peekQueue() {
            return (ThreadPoolMergeScheduler.MergeTask)((Tuple)this.enqueuedByBudget.peek()).v1();
        }

        @Override
        void postBudgetUpdate() {
            assert (this.lock.isHeldByCurrentThread());
            Tuple head = (Tuple)this.enqueuedByBudget.peek();
            if (head != null && (Long)head.v2() > this.availableBudget) {
                LOGGER.warn(String.format(Locale.ROOT, "There are merge tasks enqueued but there's insufficient disk space available to execute them (the smallest merge task requires [%d] bytes, but the available disk space is only [%d] bytes)", head.v2(), this.availableBudget));
                if (LOGGER.isDebugEnabled()) {
                    if (this.unreleasedBudgetPerElement.isEmpty()) {
                        LOGGER.debug(String.format(Locale.ROOT, "There are no merge tasks currently running, but there are [%d] enqueued ones that are blocked because of insufficient disk space (the smallest merge task requires [%d] bytes, but the available disk space is only [%d] bytes)", this.enqueuedByBudget.size(), head.v2(), this.availableBudget));
                    } else {
                        StringBuilder messageBuilder = new StringBuilder();
                        messageBuilder.append("The following merge tasks are currently running [");
                        for (Map.Entry<PriorityBlockingQueueWithBudget.ElementWithReleasableBudget, PriorityBlockingQueueWithBudget.Budgets> runningMergeTask : this.unreleasedBudgetPerElement.entrySet()) {
                            messageBuilder.append(((ThreadPoolMergeScheduler.MergeTask)runningMergeTask.getKey().element()).toString());
                            messageBuilder.append(" with disk space budgets in bytes ").append(runningMergeTask.getValue()).append(" , ");
                        }
                        messageBuilder.delete(messageBuilder.length() - 3, messageBuilder.length());
                        messageBuilder.append("], and there are [").append(this.enqueuedByBudget.size()).append("] additional enqueued ones that are blocked because of insufficient disk space");
                        messageBuilder.append(" (the smallest merge task requires [").append(head.v2()).append("] bytes, but the available disk space is only [").append(this.availableBudget).append("] bytes)");
                        LOGGER.debug(messageBuilder.toString());
                    }
                }
            }
        }
    }

    static class AtomicIORate {
        private final AtomicLong ioRate;

        AtomicIORate(long initialIORate) {
            this.ioRate = new AtomicLong(initialIORate);
        }

        long get() {
            return this.ioRate.get();
        }

        void update(LongUnaryOperator updateFunction, UpdateConsumer updateConsumer) {
            long prev = this.ioRate.get();
            long next = 0L;
            boolean haveNext = false;
            while (true) {
                if (!haveNext) {
                    next = updateFunction.applyAsLong(prev);
                }
                if (this.ioRate.weakCompareAndSetVolatile(prev, next)) {
                    updateConsumer.accept(prev, next);
                    return;
                }
                haveNext = prev == (prev = this.ioRate.get());
            }
        }

        @FunctionalInterface
        static interface UpdateConsumer {
            public void accept(long var1, long var3);
        }
    }

    static class AvailableDiskSpacePeriodicMonitor
    implements Closeable {
        private static final Logger LOGGER = LogManager.getLogger(AvailableDiskSpacePeriodicMonitor.class);
        private final NodeEnvironment.DataPath[] dataPaths;
        private final ThreadPool threadPool;
        private volatile RelativeByteSizeValue highStageWatermark;
        private volatile ByteSizeValue highStageMaxHeadroom;
        private volatile TimeValue checkInterval;
        private final Consumer<ByteSizeValue> updateConsumer;
        private volatile boolean closed;
        private volatile Scheduler.Cancellable monitor;

        AvailableDiskSpacePeriodicMonitor(NodeEnvironment.DataPath[] dataPaths, ThreadPool threadPool, RelativeByteSizeValue highStageWatermark, ByteSizeValue highStageMaxHeadroom, TimeValue checkInterval, Consumer<ByteSizeValue> updateConsumer) {
            this.dataPaths = dataPaths;
            this.threadPool = threadPool;
            this.highStageWatermark = highStageWatermark;
            this.highStageMaxHeadroom = highStageMaxHeadroom;
            this.checkInterval = checkInterval;
            this.updateConsumer = updateConsumer;
            this.closed = false;
            this.reschedule();
        }

        void setCheckInterval(TimeValue checkInterval) {
            this.checkInterval = checkInterval;
            this.reschedule();
        }

        void setHighStageWatermark(RelativeByteSizeValue highStageWatermark) {
            this.highStageWatermark = highStageWatermark;
        }

        void setHighStageMaxHeadroom(ByteSizeValue highStageMaxHeadroom) {
            this.highStageMaxHeadroom = highStageMaxHeadroom;
        }

        private synchronized void reschedule() {
            if (this.monitor != null) {
                this.monitor.cancel();
            }
            if (!this.closed && this.checkInterval.duration() > 0L) {
                this.threadPool.generic().execute(this::run);
                this.monitor = this.threadPool.scheduleWithFixedDelay(this::run, this.checkInterval, this.threadPool.generic());
            } else {
                this.monitor = null;
            }
        }

        boolean isScheduled() {
            return this.monitor != null && !this.closed;
        }

        @Override
        public void close() throws IOException {
            this.closed = true;
            this.reschedule();
        }

        private void run() {
            if (this.closed) {
                return;
            }
            FsInfo.Path mostAvailablePath = null;
            IOException fsInfoException = null;
            for (NodeEnvironment.DataPath dataPath : this.dataPaths) {
                try {
                    FsInfo.Path fsInfo = FsProbe.getFSInfo(dataPath);
                    if (mostAvailablePath != null && mostAvailablePath.getAvailable().getBytes() >= fsInfo.getAvailable().getBytes()) continue;
                    mostAvailablePath = fsInfo;
                }
                catch (IOException e) {
                    if (fsInfoException == null) {
                        fsInfoException = e;
                        continue;
                    }
                    fsInfoException.addSuppressed(e);
                }
            }
            if (fsInfoException != null) {
                LOGGER.warn("unexpected exception reading filesystem info", fsInfoException);
            }
            if (mostAvailablePath == null) {
                LOGGER.error("Cannot read filesystem info for node data paths " + Arrays.toString(this.dataPaths));
                this.updateConsumer.accept(ByteSizeValue.MINUS_ONE);
                return;
            }
            long mostAvailableDiskSpaceBytes = mostAvailablePath.getAvailable().getBytes();
            long maxMergeSizeLimit = Math.max(0L, mostAvailableDiskSpaceBytes -= AvailableDiskSpacePeriodicMonitor.getFreeBytesThreshold(mostAvailablePath.getTotal(), this.highStageWatermark, this.highStageMaxHeadroom).getBytes());
            this.updateConsumer.accept(ByteSizeValue.ofBytes(maxMergeSizeLimit));
        }

        private static ByteSizeValue getFreeBytesThreshold(ByteSizeValue total, RelativeByteSizeValue watermark, ByteSizeValue maxHeadroom) {
            if (watermark.isAbsolute()) {
                return watermark.getAbsolute();
            }
            return ByteSizeValue.subtract(total, watermark.calculateValue(total, maxHeadroom));
        }
    }

    static class PriorityBlockingQueueWithBudget<E> {
        private final ToLongFunction<? super E> budgetFunction;
        protected final PriorityQueue<Tuple<E, Long>> enqueuedByBudget;
        protected final IdentityHashMap<ElementWithReleasableBudget, Budgets> unreleasedBudgetPerElement;
        private final ReentrantLock lock;
        private final Condition elementAvailable;
        protected long availableBudget;

        PriorityBlockingQueueWithBudget(ToLongFunction<? super E> budgetFunction, long initialAvailableBudget) {
            this.budgetFunction = budgetFunction;
            this.enqueuedByBudget = new PriorityQueue<Tuple>(64, Comparator.comparingLong(Tuple::v2));
            this.unreleasedBudgetPerElement = new IdentityHashMap();
            this.lock = new ReentrantLock();
            this.elementAvailable = this.lock.newCondition();
            this.availableBudget = initialAvailableBudget;
        }

        boolean enqueue(E e) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.enqueuedByBudget.offer(new Tuple<E, Long>(e, this.budgetFunction.applyAsLong(e)));
                this.elementAvailable.signal();
            }
            finally {
                lock.unlock();
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ElementWithReleasableBudget take() throws InterruptedException {
            ReentrantLock lock = this.lock;
            lock.lockInterruptibly();
            try {
                Tuple<E, Long> head;
                while ((head = this.enqueuedByBudget.peek()) == null || head.v2() > this.availableBudget) {
                    this.elementAvailable.await();
                }
                head = this.enqueuedByBudget.poll();
                ElementWithReleasableBudget elementWithReleasableBudget = this.newElementWithReleasableBudget(head.v1(), head.v2());
                return elementWithReleasableBudget;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        int drainMatchingElementsTo(Predicate<E> predicate, Collection<? super E> c) {
            int removed = 0;
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                Iterator<Tuple<E, Long>> iterator = this.enqueuedByBudget.iterator();
                while (iterator.hasNext()) {
                    E item = iterator.next().v1();
                    if (!predicate.test(item)) continue;
                    iterator.remove();
                    c.add(item);
                    ++removed;
                }
                int n = removed;
                return n;
            }
            finally {
                lock.unlock();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void updateBudget(long availableBudget) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                this.availableBudget = availableBudget;
                this.updateBudgetOfEnqueuedElementsAndReorderQueue();
                this.unreleasedBudgetPerElement.replaceAll((e, v) -> v.updateBudgetEstimation(this.budgetFunction.applyAsLong(e.element())));
                this.availableBudget -= this.unreleasedBudgetPerElement.values().stream().mapToLong(i -> i.latestBudgetEstimationForElement).sum();
                this.elementAvailable.signalAll();
                this.postBudgetUpdate();
            }
            finally {
                lock.unlock();
            }
        }

        void postBudgetUpdate() {
            assert (this.lock.isHeldByCurrentThread());
        }

        private void updateBudgetOfEnqueuedElementsAndReorderQueue() {
            assert (this.lock.isHeldByCurrentThread());
            int queueSizeBefore = this.enqueuedByBudget.size();
            Iterator<Tuple<E, Long>> it = this.enqueuedByBudget.iterator();
            ArrayList<Tuple<E, Long>> elementsToReorder = new ArrayList<Tuple<E, Long>>();
            while (it.hasNext()) {
                long latestBudget;
                Tuple<E, Long> elementWithBudget = it.next();
                Long l = elementWithBudget.v2();
                if (l.equals(latestBudget = this.budgetFunction.applyAsLong(elementWithBudget.v1()))) continue;
                it.remove();
                elementsToReorder.add(new Tuple<E, Long>(elementWithBudget.v1(), latestBudget));
            }
            for (Tuple tuple : elementsToReorder) {
                this.enqueuedByBudget.offer(tuple);
            }
            assert (queueSizeBefore == this.enqueuedByBudget.size());
        }

        boolean isQueueEmpty() {
            return this.enqueuedByBudget.isEmpty();
        }

        boolean queueHeadIsOverTheAvailableBudget() {
            Tuple<E, Long> head = this.enqueuedByBudget.peek();
            return head != null && head.v2() > this.availableBudget;
        }

        int queueSize() {
            return this.enqueuedByBudget.size();
        }

        private ElementWithReleasableBudget newElementWithReleasableBudget(E element, long budget) {
            ElementWithReleasableBudget elementWithReleasableBudget = new ElementWithReleasableBudget(element);
            assert (this.lock.isHeldByCurrentThread());
            Budgets prev = this.unreleasedBudgetPerElement.put(elementWithReleasableBudget, new Budgets(budget, budget, this.availableBudget));
            assert (prev == null);
            this.availableBudget -= budget;
            assert (this.availableBudget >= 0L);
            return elementWithReleasableBudget;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void release(ElementWithReleasableBudget elementWithReleasableBudget) {
            ReentrantLock lock = this.lock;
            lock.lock();
            try {
                assert (!elementWithReleasableBudget.isClosed());
                Budgets val = this.unreleasedBudgetPerElement.remove(elementWithReleasableBudget);
                assert (val != null);
            }
            finally {
                lock.unlock();
            }
        }

        private boolean isReleased(ElementWithReleasableBudget elementWithReleasableBudget) {
            return !this.unreleasedBudgetPerElement.containsKey(elementWithReleasableBudget);
        }

        class ElementWithReleasableBudget
        implements Releasable {
            private final E element;

            private ElementWithReleasableBudget(E element) {
                this.element = element;
            }

            @Override
            public void close() {
                PriorityBlockingQueueWithBudget.this.release(this);
            }

            boolean isClosed() {
                return PriorityBlockingQueueWithBudget.this.isReleased(this);
            }

            E element() {
                return this.element;
            }
        }

        record Budgets(long initialBudgetEstimationForElement, long latestBudgetEstimationForElement, long initialTotalAvailableBudget) {
            Budgets updateBudgetEstimation(long latestBudgetEstimationForElement) {
                return new Budgets(this.initialBudgetEstimationForElement, latestBudgetEstimationForElement, this.initialTotalAvailableBudget);
            }
        }
    }
}

