"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TitleField = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _shared_imports = require("../../shared_imports");
var _lib = require("../../lib");
var _form_schema = require("../form_schema");
var _data_view_editor_service = require("../../data_view_editor_service");
var _title_docs_popover = require("./title_docs_popover");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/data_view_editor/public/components/form_fields/title_field.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rollupIndexPatternNoMatchError = {
  message: _i18n.i18n.translate('indexPatternEditor.rollupDataView.createIndex.noMatchError', {
    defaultMessage: 'Rollup data view error: must match one rollup index'
  })
};
const rollupIndexPatternTooManyMatchesError = {
  message: _i18n.i18n.translate('indexPatternEditor.rollupDataView.createIndex.tooManyMatchesError', {
    defaultMessage: 'Rollup data view error: can only match one rollup index'
  })
};
const mustMatchError = {
  message: _i18n.i18n.translate('indexPatternEditor.createIndex.noMatch', {
    defaultMessage: 'Name must match one or more data streams, indices, or index aliases.'
  })
};
const createMatchesIndicesValidator = ({
  rollupIndicesCapabilities,
  isRollup
}) => ({
  validator: async ({
    customData: {
      provider
    }
  }) => {
    const {
      matchedIndices,
      rollupIndex
    } = await provider();

    // verifies that the title matches at least one index, alias, or data stream
    const rollupIndices = Object.keys(rollupIndicesCapabilities);
    if (matchedIndices.exactMatchedIndices.length === 0) {
      return mustMatchError;
    }
    if (!isRollup || !rollupIndices || !rollupIndices.length) {
      return;
    }

    // A rollup index pattern needs to match one and only one rollup index.
    const rollupIndexMatches = matchedIndices.exactMatchedIndices.filter(matchedIndex => {
      var _matchedIndex$item$in, _matchedIndex$item$al;
      return rollupIndices.includes(matchedIndex.name) ||
      // matched item is alias
      ((_matchedIndex$item$in = matchedIndex.item.indices) === null || _matchedIndex$item$in === void 0 ? void 0 : _matchedIndex$item$in.length) === 1 && rollupIndices.includes(matchedIndex.item.indices[0]) ||
      // matched item is an index referenced by an alias
      ((_matchedIndex$item$al = matchedIndex.item.aliases) === null || _matchedIndex$item$al === void 0 ? void 0 : _matchedIndex$item$al.length) === 1 && rollupIndices.includes(matchedIndex.item.aliases[0]);
    });
    if (!rollupIndexMatches.length) {
      return rollupIndexPatternNoMatchError;
    } else if (rollupIndexMatches.length > 1) {
      return rollupIndexPatternTooManyMatchesError;
    }

    // Error info is potentially provided via the rollup indices caps request
    const error = rollupIndex && rollupIndicesCapabilities[rollupIndex].error;
    if (error) {
      return {
        message: _i18n.i18n.translate('indexPatternEditor.rollup.uncaughtError', {
          defaultMessage: 'Rollup data view error: {error}',
          values: {
            error
          }
        })
      };
    }
  }
});
const getTitleConfig = ({
  isRollup,
  rollupIndicesCapabilities,
  titleHelpText
}) => {
  const titleFieldConfig = _form_schema.schema.title;
  const validations = [...titleFieldConfig.validations,
  // note this is responsible for triggering the state update for the selected source list.
  createMatchesIndicesValidator({
    rollupIndicesCapabilities,
    isRollup
  })];
  return {
    ...titleFieldConfig,
    validations,
    helpText: titleHelpText
  };
};
const TitleField = ({
  isRollup,
  matchedIndices$,
  rollupIndicesCapabilities,
  indexPatternValidationProvider,
  disabled,
  titleHelpText
}) => {
  const [appendedWildcard, setAppendedWildcard] = (0, _react.useState)(false);
  const matchedIndices = (0, _useObservable.default)(matchedIndices$, _data_view_editor_service.matchedIndiciesDefault).exactMatchedIndices;
  const fieldConfig = (0, _react.useMemo)(() => getTitleConfig({
    isRollup,
    matchedIndices,
    rollupIndicesCapabilities,
    titleHelpText
  }), [isRollup, matchedIndices, rollupIndicesCapabilities, titleHelpText]);
  return /*#__PURE__*/_react.default.createElement(_shared_imports.UseField, {
    path: "title",
    config: fieldConfig,
    validationDataProvider: indexPatternValidationProvider,
    componentProps: {
      euiFieldProps: {
        'aria-label': _i18n.i18n.translate('indexPatternEditor.form.titleAriaLabel', {
          defaultMessage: 'Index pattern field'
        })
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 5
    }
  }, field => {
    const {
      isInvalid,
      errorMessage
    } = (0, _shared_imports.getFieldValidityAndErrorMessage)(field);
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: field.label,
      labelAppend: field.labelAppend,
      helpText: field.helpText,
      error: errorMessage,
      isInvalid: isInvalid,
      fullWidth: true,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      isInvalid: isInvalid,
      disabled: disabled,
      value: field.value,
      onChange: e => {
        let query = e.target.value;
        if (query.length === 1 && !appendedWildcard && (0, _lib.canAppendWildcard)(query)) {
          query += '*';
          setAppendedWildcard(true);
          setTimeout(() => e.target.setSelectionRange(1, 1));
        } else {
          if (['', '*'].includes(query) && appendedWildcard) {
            query = '';
            setAppendedWildcard(false);
          }
        }
        field.setValue(query);
      },
      isLoading: field.isValidating,
      fullWidth: true,
      "data-test-subj": "createIndexPatternTitleInput",
      append: /*#__PURE__*/_react.default.createElement(_title_docs_popover.TitleDocsPopover, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 212,
          columnNumber: 23
        }
      }),
      placeholder: "example-*",
      "data-is-validating": field.isValidating ? '1' : '0',
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 191,
        columnNumber: 13
      }
    }));
  });
};
exports.TitleField = TitleField;