"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.defaultRuntimeState = void 0;
exports.serializeRuntimeState = serializeRuntimeState;
var _lodash = require("lodash");
var _controlsConstants = require("@kbn/controls-constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const defaultRuntimeState = exports.defaultRuntimeState = {
  labelPosition: _controlsConstants.DEFAULT_CONTROLS_LABEL_POSITION,
  chainingSystem: _controlsConstants.DEFAULT_CONTROLS_CHAINING,
  autoApplySelections: _controlsConstants.DEFAULT_AUTO_APPLY_SELECTIONS,
  ignoreParentSettings: _controlsConstants.DEFAULT_IGNORE_PARENT_SETTINGS
};

/**
 * @deprecated use controlGroupApi.serializeState
 * Converts runtime state to serialized state
 * Only use for BWC when runtime state needs to be converted outside of ControlGroup api
 */
function serializeRuntimeState(runtimeState) {
  var _runtimeState$initial;
  return {
    rawState: {
      ...defaultRuntimeState,
      ...(0, _lodash.omit)(runtimeState, ['initialChildControlState']),
      controls: Object.entries((_runtimeState$initial = runtimeState === null || runtimeState === void 0 ? void 0 : runtimeState.initialChildControlState) !== null && _runtimeState$initial !== void 0 ? _runtimeState$initial : {}).map(([controlId, value]) => {
        const {
          grow,
          order,
          type,
          width,
          ...controlConfig
        } = value;
        return {
          id: controlId,
          grow,
          order,
          type,
          width,
          controlConfig
        };
      })
    }
  };
}