"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateOptionsSchema = exports.searchResultSchema = exports.searchOptionsSchemas = exports.schemaAndOr = exports.savedObjectSchema = exports.referencesSchema = exports.referenceSchema = exports.objectTypeToGetResultSchema = exports.createResultSchema = exports.createOptionsSchemas = exports.apiError = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const apiError = exports.apiError = _configSchema.schema.object({
  error: _configSchema.schema.string(),
  message: _configSchema.schema.string(),
  statusCode: _configSchema.schema.number(),
  metadata: _configSchema.schema.object({}, {
    unknowns: 'allow'
  })
});
const referenceSchema = exports.referenceSchema = _configSchema.schema.object({
  name: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  id: _configSchema.schema.string()
}, {
  unknowns: 'forbid'
});
const referencesSchema = exports.referencesSchema = _configSchema.schema.arrayOf(referenceSchema);
const savedObjectSchema = attributesSchema => _configSchema.schema.object({
  id: _configSchema.schema.string(),
  type: _configSchema.schema.string(),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedAt: _configSchema.schema.maybe(_configSchema.schema.string()),
  createdBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  updatedBy: _configSchema.schema.maybe(_configSchema.schema.string()),
  error: _configSchema.schema.maybe(apiError),
  attributes: attributesSchema,
  references: referencesSchema,
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  originId: _configSchema.schema.maybe(_configSchema.schema.string()),
  managed: _configSchema.schema.maybe(_configSchema.schema.boolean())
}, {
  unknowns: 'allow'
});
exports.savedObjectSchema = savedObjectSchema;
const objectTypeToGetResultSchema = soSchema => _configSchema.schema.object({
  item: soSchema,
  meta: _configSchema.schema.object({
    outcome: _configSchema.schema.oneOf([_configSchema.schema.literal('exactMatch'), _configSchema.schema.literal('aliasMatch'), _configSchema.schema.literal('conflict')]),
    aliasTargetId: _configSchema.schema.maybe(_configSchema.schema.string()),
    aliasPurpose: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('savedObjectConversion'), _configSchema.schema.literal('savedObjectImport')]))
  }, {
    unknowns: 'forbid'
  })
}, {
  unknowns: 'forbid'
});

// its recommended to create a subset of this schema for stricter validation
exports.objectTypeToGetResultSchema = objectTypeToGetResultSchema;
const createOptionsSchemas = exports.createOptionsSchemas = {
  id: _configSchema.schema.maybe(_configSchema.schema.string()),
  references: _configSchema.schema.maybe(referencesSchema),
  overwrite: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  refresh: _configSchema.schema.maybe(_configSchema.schema.boolean()),
  initialNamespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  managed: _configSchema.schema.maybe(_configSchema.schema.boolean())
};
const schemaAndOr = exports.schemaAndOr = _configSchema.schema.oneOf([_configSchema.schema.literal('AND'), _configSchema.schema.literal('OR')]);

// its recommended to create a subset of this schema for stricter validation
const searchOptionsSchemas = exports.searchOptionsSchemas = {
  page: _configSchema.schema.maybe(_configSchema.schema.number()),
  perPage: _configSchema.schema.maybe(_configSchema.schema.number()),
  sortField: _configSchema.schema.maybe(_configSchema.schema.string()),
  sortOrder: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.literal('asc'), _configSchema.schema.literal('desc')])),
  fields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  search: _configSchema.schema.maybe(_configSchema.schema.string()),
  searchFields: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())])),
  rootSearchFields: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  hasReference: _configSchema.schema.maybe(_configSchema.schema.oneOf([referenceSchema, _configSchema.schema.arrayOf(referenceSchema)])),
  hasReferenceOperator: _configSchema.schema.maybe(schemaAndOr),
  hasNoReference: _configSchema.schema.maybe(_configSchema.schema.oneOf([referenceSchema, _configSchema.schema.arrayOf(referenceSchema)])),
  hasNoReferenceOperator: _configSchema.schema.maybe(schemaAndOr),
  defaultSearchOperator: _configSchema.schema.maybe(schemaAndOr),
  namespaces: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.string())),
  type: _configSchema.schema.maybe(_configSchema.schema.string()),
  filter: _configSchema.schema.maybe(_configSchema.schema.string()),
  pit: _configSchema.schema.maybe(_configSchema.schema.object({
    id: _configSchema.schema.string(),
    keepAlive: _configSchema.schema.maybe(_configSchema.schema.string())
  }))
};

// its recommended to create a subset of this schema for stricter validation
const updateOptionsSchema = exports.updateOptionsSchema = {
  references: _configSchema.schema.maybe(referencesSchema),
  version: _configSchema.schema.maybe(_configSchema.schema.string()),
  refresh: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.boolean(), _configSchema.schema.literal('wait_for')])),
  upsert: attributesSchema => _configSchema.schema.maybe(savedObjectSchema(attributesSchema)),
  retryOnConflict: _configSchema.schema.maybe(_configSchema.schema.number()),
  mergeAttributes: _configSchema.schema.maybe(_configSchema.schema.boolean())
};
const createResultSchema = soSchema => _configSchema.schema.object({
  item: soSchema
}, {
  unknowns: 'forbid'
});
exports.createResultSchema = createResultSchema;
const searchResultSchema = (soSchema, meta) => _configSchema.schema.object({
  hits: _configSchema.schema.arrayOf(soSchema),
  pagination: _configSchema.schema.object({
    total: _configSchema.schema.number(),
    cursor: _configSchema.schema.maybe(_configSchema.schema.string())
  }),
  ...(meta && {
    meta
  })
}, {
  unknowns: 'forbid'
});
exports.searchResultSchema = searchResultSchema;