"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GeneratedConfigFields = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _routes = require("../../routes");
var _connector_view_search_indices_details = require("../../shared/connector_view_search_indices_details/connector_view_search_indices_details");
var _encode_path_params = require("../../shared/encode_path_params");
var _react_router_helpers = require("../../shared/react_router_helpers");
var _constants = require("../../../../common/constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/content_connectors/public/components/connector_detail/components/generated_config_fields.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ConfirmModal = ({
  onCancel,
  onConfirm,
  focusTrapProps
}) => {
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.apiKey.confirmModal.title', {
      defaultMessage: 'Generate an Elasticsearch API key'
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onCancel,
    onConfirm: onConfirm,
    cancelButtonText: _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.apiKey.confirmModal.cancelButton.label', {
      defaultMessage: 'Cancel'
    }),
    confirmButtonText: _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.apiKey.confirmModal.confirmButton.label', {
      defaultMessage: 'Generate API key'
    }),
    defaultFocusedButton: "confirm",
    focusTrapProps: focusTrapProps,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.content.indices.configurationConnector.apiKey.confirmModal.description', {
    defaultMessage: 'Generating a new API key will invalidate the previous key. Are you sure you want to generate a new API key? This can not be undone.'
  }));
};
const GeneratedConfigFields = ({
  apiKey,
  connector,
  generateApiKey,
  isGenerateLoading
}) => {
  const generateButtonRef = (0, _react.useRef)(null);
  const refreshButtonRef = (0, _react.useRef)(null);
  const [isModalVisible, setIsModalVisible] = (0, _react.useState)(false);
  const refreshButtonClick = () => {
    setIsModalVisible(true);
  };
  const onCancel = () => {
    setIsModalVisible(false);
  };
  const onConfirm = () => {
    if (generateApiKey) generateApiKey();
    setIsModalVisible(false);
  };
  const showApiKeyInfoForSelfManagedConnector = !connector.is_native;
  const showApiKeyBanner = showApiKeyInfoForSelfManagedConnector && (apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isModalVisible && /*#__PURE__*/_react.default.createElement(ConfirmModal, {
    onCancel: onCancel,
    onConfirm: onConfirm,
    focusTrapProps: {
      returnFocus: () => {
        if (generateButtonRef.current) {
          generateButtonRef.current.focus();
          return false;
        }
        if (refreshButtonRef.current) {
          refreshButtonRef.current.focus();
          return false;
        }
        return true;
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGrid, {
    columns: 3,
    alignItems: "center",
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 139,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 142,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 143,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 144,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.connectorCreatedFlexItemLabel', {
    defaultMessage: 'Connector created'
  })))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    external: true,
    target: "_blank",
    to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_PATH, {
      connectorId: connector.id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 155,
      columnNumber: 13
    }
  }, connector.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 165,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_react_router_helpers.EuiLinkTo, {
    external: true,
    target: "_blank",
    to: (0, _encode_path_params.generateEncodedPath)(_routes.CONNECTOR_DETAIL_PATH, {
      connectorId: connector.id
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 17
    }
  }, connector.id)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 183,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: connector.id,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 184,
      columnNumber: 17
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    "data-test-subj": "enterpriseSearchConnectorDeploymentButton",
    iconType: "copyClipboard",
    onClick: copy,
    "aria-label": _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.copyConnectorId', {
      defaultMessage: 'Copy connector ID'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 186,
      columnNumber: 21
    }
  }))))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 201,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 202,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 203,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 204,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 206,
      columnNumber: 15
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.indexCreatedFlexItemLabel', {
    defaultMessage: 'Index created'
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 214,
      columnNumber: 11
    }
  }, connector.index_name && /*#__PURE__*/_react.default.createElement(_connector_view_search_indices_details.ConnectorViewIndexLink, {
    indexName: connector.index_name,
    target: true,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 216,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 219,
      columnNumber: 11
    }
  }), showApiKeyInfoForSelfManagedConnector && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 222,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 223,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 224,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "check",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 225,
      columnNumber: 21
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 227,
      columnNumber: 19
    }
  }, _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.apiKeyCreatedFlexItemLabel', {
    defaultMessage: 'API key created'
  }), (apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded) && ` *`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 236,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
    "data-test-subj": "enterpriseSearchConnectorDeploymentLink",
    href: (0, _encode_path_params.generateEncodedPath)(_constants.MANAGE_API_KEYS_URL, {}),
    external: true,
    target: "_blank",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 237,
      columnNumber: 17
    }
  }, apiKey === null || apiKey === void 0 ? void 0 : apiKey.name)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 246,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    gutterSize: "xs",
    justifyContent: "flexEnd",
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 247,
      columnNumber: 17
    }
  }, apiKey !== null && apiKey !== void 0 && apiKey.encoded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 254,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCopy, {
    textToCopy: apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 255,
      columnNumber: 23
    }
  }, copy => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    gutterSize: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 257,
      columnNumber: 27
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 258,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 31
    }
  }, apiKey === null || apiKey === void 0 ? void 0 : apiKey.encoded)), generateApiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 262,
      columnNumber: 31
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "enterpriseSearchGeneratedConfigFieldsButton",
    size: "xs",
    iconType: "refresh",
    buttonRef: refreshButtonRef,
    isLoading: isGenerateLoading,
    onClick: refreshButtonClick,
    disabled: !connector.index_name,
    "aria-label": _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.refreshAPIKey', {
      defaultMessage: 'Refresh an Elasticsearch API key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 263,
      columnNumber: 33
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 278,
      columnNumber: 29
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    size: "xs",
    "data-test-subj": "enterpriseSearchConnectorDeploymentButton",
    iconType: "copyClipboard",
    onClick: copy,
    "aria-label": _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.copyIndexName', {
      defaultMessage: 'Copy index name'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 279,
      columnNumber: 31
    }
  }))))) : generateApiKey && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 296,
      columnNumber: 23
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "enterpriseSearchGeneratedConfigFieldsButton",
    size: "xs",
    iconType: "refresh",
    buttonRef: generateButtonRef,
    isLoading: isGenerateLoading,
    onClick: refreshButtonClick,
    disabled: !connector.index_name,
    "aria-label": _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.generateAPIKey', {
      defaultMessage: 'Generate an Elasticsearch API key'
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 297,
      columnNumber: 25
    }
  })))))), showApiKeyBanner && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
    announceOnMount: true,
    color: "success",
    size: "s",
    title: _i18n.i18n.translate('xpack.contentConnectors.connectorDeployment.generatedConfigCallout', {
      defaultMessage: `You'll only see this API key once, so save it somewhere safe. We don't store your API keys, so if you lose a key you'll need to generate a replacement`
    }),
    iconType: "asterisk",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 321,
      columnNumber: 13
    }
  }))));
};
exports.GeneratedConfigFields = GeneratedConfigFields;