"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useRestoreHistory = void 0;
var _react = require("react");
var _reactRouterDom = require("react-router-dom");
var _reactRedux = require("react-redux");
var _history = require("../../../state/actions/history");
var _workpad = require("../../../state/actions/workpad");
var _route_state = require("../route_state");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// @ts-expect-error

const useRestoreHistory = () => {
  const history = (0, _reactRouterDom.useHistory)();
  const location = (0, _reactRouterDom.useLocation)();
  const dispatch = (0, _reactRedux.useDispatch)();
  const {
    state: historyState
  } = location;
  const previousState = (0, _react.useRef)(historyState);
  const historyAction = history.action.toLowerCase();
  (0, _react.useEffect)(() => {
    const isBrowserNav = historyAction === 'pop' && historyState != null;
    if (isBrowserNav && historyState !== previousState.current) {
      previousState.current = historyState;
      dispatch((0, _history.restoreHistory)((0, _route_state.decode)(historyState)));
      dispatch((0, _workpad.initializeWorkpad)());
    }
    previousState.current = historyState;
  }, [dispatch, historyAction, historyState]);
};
exports.useRestoreHistory = useRestoreHistory;