"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClearablePalettePicker = void 0;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _utils = require("../utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/palette_picker/palette_picker/clearable_palette_picker.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const strings = {
  getEmptyPaletteLabel: () => _i18n.i18n.translate('xpack.canvas.palettePicker.emptyPaletteLabel', {
    defaultMessage: 'None'
  })
};
const ClearablePalettePicker = props => {
  var _foundPalette$id;
  const {
    palette,
    palettes,
    onChange = () => {}
  } = props;
  const colorPalettes = palettes.map(_utils.prepareColorPalette);
  const onPickerChange = value => {
    const canvasPalette = palettes.find(item => item.id === value);
    onChange(canvasPalette || null);
  };
  const foundPalette = (0, _utils.findPalette)(palette !== null && palette !== void 0 ? palette : null, palettes);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiColorPalettePicker, {
    id: props.id,
    compressed: true,
    palettes: [{
      value: 'clear',
      title: strings.getEmptyPaletteLabel(),
      type: 'text'
    }, ...colorPalettes],
    onChange: onPickerChange,
    valueOfSelected: (_foundPalette$id = foundPalette === null || foundPalette === void 0 ? void 0 : foundPalette.id) !== null && _foundPalette$id !== void 0 ? _foundPalette$id : 'clear',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 34,
      columnNumber: 5
    }
  });
};
exports.ClearablePalettePicker = ClearablePalettePicker;