"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CustomTooltip = CustomTooltip;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _service_nodes = require("../../../../../common/service_nodes");
var _formatters = require("../../../../../common/utils/formatters");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1763294637718354027/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/instances_latency_distribution_chart/custom_tooltip.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const latencyLabel = _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipLatencyLabel', {
  defaultMessage: 'Latency'
});
const throughputLabel = _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipThroughputLabel', {
  defaultMessage: 'Throughput'
});
const clickToFilterDescription = _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipClickToFilterDescription', {
  defaultMessage: 'Click to filter by instance'
});

/**
 * Tooltip for a single instance
 */
function SingleInstanceCustomTooltip({
  latencyFormatter,
  values
}) {
  const value = values[0];
  const {
    color
  } = value;
  const datum = value.datum;
  const {
    latency,
    serviceNodeName,
    throughput
  } = datum;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__header",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 7
    }
  }, (0, _service_nodes.getServiceNodeName)(serviceNodeName)), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__list",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--backgroundColor",
    style: {
      backgroundColor: 'transparent'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 60,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--color",
    style: {
      backgroundColor: color
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--container",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__label",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 13
    }
  }, latencyLabel), /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__value",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, latencyFormatter(latency).formatted))), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--backgroundColor",
    style: {
      backgroundColor: 'transparent'
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--color",
    style: {
      backgroundColor: color
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__item--container",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__label",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 13
    }
  }, throughputLabel), /*#__PURE__*/_react.default.createElement("span", {
    className: "echTooltip__value",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 13
    }
  }, (0, _formatters.asTransactionRate)(throughput))))));
}

/**
 * Tooltip for a multiple instances
 */
function MultipleInstanceCustomTooltip({
  latencyFormatter,
  values
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip__header",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 7
    }
  }, _i18n.i18n.translate('xpack.apm.instancesLatencyDistributionChartTooltipInstancesTitle', {
    defaultMessage: '{instancesCount} {instancesCount, plural, one {instance} other {instances}}',
    values: {
      instancesCount: values.length
    }
  })), values.map(value => {
    const {
      color,
      seriesIdentifier
    } = value;
    const datum = value.datum;
    const {
      latency,
      serviceNodeName,
      throughput
    } = datum;
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__list",
      key: seriesIdentifier.key,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--backgroundColor",
      style: {
        backgroundColor: 'transparent'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--color",
      style: {
        backgroundColor: color
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--container",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 120,
        columnNumber: 17
      }
    }, (0, _service_nodes.getServiceNodeName)(serviceNodeName)))), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--backgroundColor",
      style: {
        backgroundColor: 'transparent'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--color",
      style: {
        backgroundColor: color
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--container",
      style: {
        paddingLeft: euiTheme.size.s
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 130,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 131,
        columnNumber: 17
      }
    }, latencyLabel), /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__value",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 132,
        columnNumber: 17
      }
    }, latencyFormatter(latency).formatted))), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--backgroundColor",
      style: {
        backgroundColor: 'transparent'
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 136,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--color",
      style: {
        backgroundColor: color
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 17
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      className: "echTooltip__item--container",
      style: {
        paddingLeft: euiTheme.size.s
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__label",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 17
      }
    }, throughputLabel), /*#__PURE__*/_react.default.createElement("span", {
      className: "echTooltip__value",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 144,
        columnNumber: 17
      }
    }, (0, _formatters.asTransactionRate)(throughput)))));
  }));
}

/**
 * Custom tooltip for instances latency distribution chart.
 *
 * The styling provided here recreates that in the Elastic Charts tooltip: https://github.com/elastic/elastic-charts/blob/58e6b5fbf77f4471d2a9a41c45a61f79ebd89b65/src/components/tooltip/tooltip.tsx
 *
 * We probably won't need to do all of this once https://github.com/elastic/elastic-charts/issues/615 is completed.
 */
function CustomTooltip(props) {
  const {
    values
  } = props;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement("div", {
    className: "echTooltip",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 166,
      columnNumber: 5
    }
  }, values.length > 1 ? /*#__PURE__*/_react.default.createElement(MultipleInstanceCustomTooltip, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 9
    }
  })) : /*#__PURE__*/_react.default.createElement(SingleInstanceCustomTooltip, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 170,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement("div", {
    style: {
      padding: euiTheme.size.xs
    },
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
    type: "filter",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 173,
      columnNumber: 9
    }
  }), " ", clickToFilterDescription));
}