"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkEditRulesOcc = bulkEditRulesOcc;
var _pMap = _interopRequireDefault(require("p-map"));
var _get_schedule_frequency = require("../../../application/rule/methods/get_schedule_frequency");
var _saved_objects = require("../../../saved_objects");
var _lib = require("../../lib");
var _rule = require("../../../data/rule");
var _types = require("../../../types");
var _constants = require("../constants");
var _bulk_mark_api_keys_for_invalidation = require("../../../invalidate_pending_api_keys/bulk_mark_api_keys_for_invalidation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const isValidInterval = interval => {
  return interval !== undefined;
};
async function bulkEditRulesOcc(context, options) {
  const rulesFinder = await context.encryptedSavedObjectsClient.createPointInTimeFinderDecryptedAsInternalUser({
    filter: options.filter,
    type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
    perPage: 100,
    ...(context.namespace ? {
      namespaces: [context.namespace]
    } : undefined)
  });
  const rules = [];
  const skipped = [];
  const errors = [];
  const apiKeysMap = new Map();
  const username = await context.getUserName();
  const prevInterval = [];
  for await (const response of rulesFinder.find()) {
    context.logger.info(`response.saved_objects ${JSON.stringify(response.saved_objects)}`);
    if (options.shouldValidateSchedule) {
      const intervals = response.saved_objects.filter(rule => rule.attributes.enabled).map(rule => {
        var _rule$attributes$sche;
        return (_rule$attributes$sche = rule.attributes.schedule) === null || _rule$attributes$sche === void 0 ? void 0 : _rule$attributes$sche.interval;
      }).filter(isValidInterval);
      prevInterval.concat(intervals);
    }
    await (0, _lib.bulkMigrateLegacyActions)({
      context,
      rules: response.saved_objects
    });
    await (0, _pMap.default)(response.saved_objects, async rule => options.updateFn({
      rule,
      apiKeysMap,
      rules,
      skipped,
      errors,
      username
    }), {
      concurrency: _constants.API_KEY_GENERATE_CONCURRENCY
    });
  }
  await rulesFinder.close();
  if (options.shouldValidateSchedule) {
    const updatedInterval = rules.filter(rule => rule.attributes.enabled).map(rule => {
      var _rule$attributes$sche2;
      return (_rule$attributes$sche2 = rule.attributes.schedule) === null || _rule$attributes$sche2 === void 0 ? void 0 : _rule$attributes$sche2.interval;
    }).filter(isValidInterval);
    let validationPayload = null;
    validationPayload = await (0, _get_schedule_frequency.validateScheduleLimit)({
      context,
      prevInterval,
      updatedInterval
    });
    if (validationPayload) {
      return {
        apiKeysToInvalidate: options.shouldInvalidateApiKeys ? Array.from(apiKeysMap.values()).filter(value => value.newApiKey).map(value => value.newApiKey) : [],
        resultSavedObjects: [],
        rules: [],
        errors: rules.map(rule => ({
          message: (0, _types.getRuleCircuitBreakerErrorMessage)({
            name: rule.attributes.name || 'n/a',
            interval: validationPayload.interval,
            intervalAvailable: validationPayload.intervalAvailable,
            action: 'bulkEdit',
            rules: updatedInterval.length
          }),
          rule: {
            id: rule.id,
            name: rule.attributes.name || 'n/a'
          }
        })),
        skipped: []
      };
    }
  }
  if (rules.length === 0) {
    return {
      apiKeysToInvalidate: [],
      resultSavedObjects: [],
      rules,
      errors,
      skipped
    };
  }
  const {
    result,
    apiKeysToInvalidate
  } = await saveBulkUpdatedRules({
    context,
    rules,
    apiKeysMap,
    shouldInvalidateApiKeys: options.shouldInvalidateApiKeys
  });
  return {
    apiKeysToInvalidate: options.shouldInvalidateApiKeys ? apiKeysToInvalidate : [],
    resultSavedObjects: result.saved_objects,
    errors,
    rules,
    skipped
  };
}
async function saveBulkUpdatedRules({
  context,
  rules,
  apiKeysMap,
  shouldInvalidateApiKeys
}) {
  const apiKeysToInvalidate = [];
  let result;
  try {
    // TODO (http-versioning): for whatever reasoning we are using SavedObjectsBulkUpdateObject
    // everywhere when it should be SavedObjectsBulkCreateObject. We need to fix it in
    // bulk_disable, bulk_enable, etc. to fix this cast
    result = await (0, _rule.bulkCreateRulesSo)({
      savedObjectsClient: context.unsecuredSavedObjectsClient,
      bulkCreateRuleAttributes: rules,
      savedObjectsBulkCreateOptions: {
        overwrite: true
      }
    });
  } catch (e) {
    // avoid unused newly generated API keys
    if (apiKeysMap.size > 0) {
      const newKeys = Array.from(apiKeysMap.values()).filter(value => value.newApiKey && !value.newApiKeyCreatedByUser).map(value => value.newApiKey);
      if (newKeys.length > 0) {
        await (0, _bulk_mark_api_keys_for_invalidation.bulkMarkApiKeysForInvalidation)({
          apiKeys: newKeys
        }, context.logger, context.unsecuredSavedObjectsClient);
      }
    }
    throw e;
  }
  if (shouldInvalidateApiKeys) {
    result.saved_objects.map(({
      id,
      error
    }) => {
      var _apiKeysMap$get, _apiKeysMap$get2, _apiKeysMap$get3, _apiKeysMap$get4;
      const oldApiKey = (_apiKeysMap$get = apiKeysMap.get(id)) === null || _apiKeysMap$get === void 0 ? void 0 : _apiKeysMap$get.oldApiKey;
      const oldApiKeyCreatedByUser = (_apiKeysMap$get2 = apiKeysMap.get(id)) === null || _apiKeysMap$get2 === void 0 ? void 0 : _apiKeysMap$get2.oldApiKeyCreatedByUser;
      const newApiKey = (_apiKeysMap$get3 = apiKeysMap.get(id)) === null || _apiKeysMap$get3 === void 0 ? void 0 : _apiKeysMap$get3.newApiKey;
      const newApiKeyCreatedByUser = (_apiKeysMap$get4 = apiKeysMap.get(id)) === null || _apiKeysMap$get4 === void 0 ? void 0 : _apiKeysMap$get4.newApiKeyCreatedByUser;

      // if SO wasn't saved and has new API key it will be invalidated
      if (error && newApiKey && !newApiKeyCreatedByUser) {
        apiKeysToInvalidate.push(newApiKey);
        // if SO saved and has old Api Key it will be invalidate
      } else if (!error && oldApiKey && !oldApiKeyCreatedByUser) {
        apiKeysToInvalidate.push(oldApiKey);
      }
    });
  }
  return {
    result,
    apiKeysToInvalidate
  };
}