"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.PlanParamsOperationsManager = void 0;
const core_1 = require("@inversifyjs/core");
class PlanParamsOperationsManager {
    planParamsOperations;
    #serviceReferenceManager;
    constructor(serviceReferenceManager) {
        this.#serviceReferenceManager = serviceReferenceManager;
        this.planParamsOperations = {
            getBindings: this.#serviceReferenceManager.bindingService.get.bind(this.#serviceReferenceManager.bindingService),
            getBindingsChained: this.#serviceReferenceManager.bindingService.getChained.bind(this.#serviceReferenceManager.bindingService),
            getClassMetadata: core_1.getClassMetadata,
            getPlan: this.#serviceReferenceManager.planResultCacheService.get.bind(this.#serviceReferenceManager.planResultCacheService),
            setBinding: this.#setBinding.bind(this),
            setNonCachedServiceNode: this.#serviceReferenceManager.planResultCacheService.setNonCachedServiceNode.bind(this.#serviceReferenceManager.planResultCacheService),
            setPlan: this.#serviceReferenceManager.planResultCacheService.set.bind(this.#serviceReferenceManager.planResultCacheService),
        };
        this.#serviceReferenceManager.onReset(() => {
            this.#resetComputedProperties();
        });
    }
    #resetComputedProperties() {
        this.planParamsOperations.getBindings =
            this.#serviceReferenceManager.bindingService.get.bind(this.#serviceReferenceManager.bindingService);
        this.planParamsOperations.getBindingsChained =
            this.#serviceReferenceManager.bindingService.getChained.bind(this.#serviceReferenceManager.bindingService);
        this.planParamsOperations.setBinding = this.#setBinding.bind(this);
    }
    #setBinding(binding) {
        this.#serviceReferenceManager.bindingService.set(binding);
        this.#serviceReferenceManager.planResultCacheService.invalidateServiceBinding({
            binding: binding,
            kind: core_1.CacheBindingInvalidationKind.bindingAdded,
            operations: this.planParamsOperations,
        });
    }
}
exports.PlanParamsOperationsManager = PlanParamsOperationsManager;
//# sourceMappingURL=PlanParamsOperationsManager.js.map