"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFlyoutChildStyles = void 0;
var _react = require("@emotion/react");
var _global_styling = require("../../global_styling");
var _flyout = require("./flyout.styles");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var euiFlyoutChildStyles = exports.euiFlyoutChildStyles = function euiFlyoutChildStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  return {
    // Base styles for the child flyout
    euiFlyoutChild: /*#__PURE__*/(0, _react.css)("position:absolute;inset-block-start:0;inset-inline-start:0;block-size:100%;display:flex;flex-direction:column;", (0, _global_styling.logicalCSSWithFallback)('overflow-y', 'hidden'), " ", (0, _global_styling.logicalCSS)('height', '100%'), " z-index:", Number(euiTheme.levels.flyout) + 1, ";border-inline-start:", euiTheme.border.thin, ";", (0, _flyout.maxedFlyoutWidth)(euiThemeContext), ";;label:euiFlyoutChild;"),
    backgroundDefault: /*#__PURE__*/(0, _react.css)("background:", euiTheme.colors.backgroundBasePlain, ";;label:backgroundDefault;"),
    backgroundShaded: /*#__PURE__*/(0, _react.css)("background:", euiTheme.colors.backgroundBaseSubdued, ";;label:backgroundShaded;"),
    // Position variants based on screen size
    sidePosition: /*#__PURE__*/(0, _react.css)("transform:translateX(-100%);border-inline-end:", euiTheme.border.thin, ";;label:sidePosition;"),
    stackedPosition: /*#__PURE__*/(0, _react.css)("inset-inline-end:0;inline-size:100%;border-block-end:", euiTheme.border.thin, ";;label:stackedPosition;"),
    s: /*#__PURE__*/(0, _react.css)((0, _flyout.composeFlyoutSizing)(euiThemeContext, 's'), ";;label:s;"),
    m: /*#__PURE__*/(0, _react.css)((0, _flyout.composeFlyoutSizing)(euiThemeContext, 'm'), ";;label:m;"),
    overflow: {
      overflow: /*#__PURE__*/(0, _react.css)("flex-grow:1;display:flex;flex-direction:column;", (0, _global_styling.euiYScroll)(euiThemeContext), ";;label:overflow;"),
      wrapper: /*#__PURE__*/(0, _react.css)("display:flex;flex-direction:column;flex-grow:1;", (0, _global_styling.logicalCSS)('overflow-x', 'auto'), ";;label:wrapper;")
    },
    banner: /*#__PURE__*/(0, _react.css)((0, _global_styling.logicalCSSWithFallback)('overflow-x', 'hidden'), " ", (0, _global_styling.highContrastModeStyles)(euiThemeContext, {
      preferred: (0, _global_styling.logicalCSS)('border-bottom', euiTheme.border.thin)
    }), ";;label:banner;")
  };
};