"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.convertRangeToISO = exports.convertDateToISOString = exports.buildScopedInternalSavedObjectsClientUnsafe = exports.buildFakeScopedRequest = void 0;
var _datemath = _interopRequireDefault(require("@kbn/datemath"));
var _server = require("@kbn/spaces-plugin/server");
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const convertDateToISOString = dateString => {
  const date = _datemath.default.parse(dateString);
  if (date !== null && date !== void 0 && date.isValid()) {
    return date.toISOString();
  } else {
    throw new Error(`Could not convert string "${dateString}" to ISO string`);
  }
};
exports.convertDateToISOString = convertDateToISOString;
const convertRangeToISO = range => ({
  start: convertDateToISOString(range.start),
  end: convertDateToISOString(range.end)
});
exports.convertRangeToISO = convertRangeToISO;
const buildFakeScopedRequest = ({
  coreStart,
  namespace
}) => {
  const rawRequest = {
    headers: {},
    path: '/'
  };
  const request = (0, _coreHttpServerUtils.kibanaRequestFactory)(rawRequest);
  const scopedPath = (0, _server.addSpaceIdToPath)('/', namespace);
  coreStart.http.basePath.set(request, scopedPath);
  return request;
};

/**
 *  Builds a SavedObjectsClient scoped to the given namespace. This should be used with caution, and only in cases where a real kibana request is not available to build a proper scoped client (e.g. a task manager task).
 *
 __Note__: Because the kibana system user cannot access SavedObjects itself, this client does not have the security extension enabled, which has (negative) implications both for logging and for security.
 * @param coreStart CoreStart plugin context
 * @param namespace the namespace to which the client should be scoped
 * @returns a SavedObjectsClient scoped to the given namespace
 */
exports.buildFakeScopedRequest = buildFakeScopedRequest;
const buildScopedInternalSavedObjectsClientUnsafe = ({
  coreStart,
  namespace
}) => {
  const fakeScopedRequest = buildFakeScopedRequest({
    coreStart,
    namespace
  });
  return coreStart.savedObjects.getScopedClient(fakeScopedRequest, {
    excludedExtensions: [_coreSavedObjectsServer.SECURITY_EXTENSION_ID]
  });
};
exports.buildScopedInternalSavedObjectsClientUnsafe = buildScopedInternalSavedObjectsClientUnsafe;