"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createGetRiskScores = void 0;
var _security_solution = require("../../../../common/search_strategy/security_solution");
var _queryRisk_score = require("../../../search_strategy/security_solution/factory/risk_score/all/query.risk_score.dsl");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createGetRiskScores = ({
  logger,
  esClient,
  spaceId
}) => async ({
  entityIdentifier,
  entityType,
  pagination
}) => {
  const query = (0, _queryRisk_score.buildRiskScoreQuery)({
    filterQuery: (0, _security_solution.buildEntityNameFilter)(entityType, [entityIdentifier]),
    defaultIndex: [(0, _security_solution.getRiskIndex)(spaceId, false)],
    pagination,
    riskScoreEntity: entityType
  });
  const response = await esClient.search(query);
  return response.hits.hits.map(hit => hit._source ? hit._source[entityType].risk : undefined).filter(risk => risk !== undefined);
};
exports.createGetRiskScores = createGetRiskScores;