"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.privilegesCheckPrivilegeMonitoringRoute = void 0;
var _utils = require("@kbn/lists-plugin/server/routes/utils");
var _securitysolutionEsUtils = require("@kbn/securitysolution-es-utils");
var _constants = require("../../../../../common/constants");
var _privilege_monitoring_privileges = require("../privilege_monitoring_privileges");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const privilegesCheckPrivilegeMonitoringRoute = (router, logger, getStartServices) => {
  router.versioned.get({
    access: 'public',
    path: _constants.PRIVMON_PRIVILEGE_CHECK_API,
    security: {
      authz: {
        requiredPrivileges: ['securitySolution', `${_constants.APP_ID}-entity-analytics`]
      }
    }
  }).addVersion({
    version: _constants.API_VERSIONS.public.v1,
    validate: {}
  }, async (context, request, response) => {
    const siemResponse = (0, _utils.buildSiemResponse)(response);
    const secSol = await context.securitySolution;
    const spaceId = secSol.getSpaceId();
    const [_, {
      security
    }] = await getStartServices();
    try {
      const body = await (0, _privilege_monitoring_privileges.getReadPrivilegeUserMonitoringPrivileges)(request, security, spaceId);
      return response.ok({
        body
      });
    } catch (e) {
      const error = (0, _securitysolutionEsUtils.transformError)(e);
      logger.error(`Error checking privilege monitoring privileges: ${error.message}`);
      return siemResponse.error({
        statusCode: error.statusCode,
        body: error.message
      });
    }
  });
};
exports.privilegesCheckPrivilegeMonitoringRoute = privilegesCheckPrivilegeMonitoringRoute;