"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VERSION = exports.TYPE = exports.TIMEOUT = exports.SCOPE = exports.PRIVILEGE_MONITORING_ENGINE_STATUS = exports.PRE_EXCLUDE_INDICES = exports.POST_EXCLUDE_INDICES = exports.INTERVAL = void 0;
var _constants = require("../../../../common/constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const SCOPE = exports.SCOPE = ['securitySolution'];
const TYPE = exports.TYPE = 'entity_analytics:monitoring:privileges:engine';
const VERSION = exports.VERSION = '1.0.0';
const TIMEOUT = exports.TIMEOUT = '10m';
const INTERVAL = exports.INTERVAL = '10m';
const PRIVILEGE_MONITORING_ENGINE_STATUS = exports.PRIVILEGE_MONITORING_ENGINE_STATUS = {
  // TODO Make the engine initialization async before uncommenting these lines
  // Also implement a status API for FE to poll
  // INSTALLING: 'installing',
  // STOPPED: 'stopped',
  STARTED: 'started',
  ERROR: 'error',
  DISABLED: 'disabled',
  NOT_INSTALLED: 'not_installed'
};

// Indices that are exclude from the search
const PRE_EXCLUDE_INDICES = exports.PRE_EXCLUDE_INDICES = [..._constants.INCLUDE_INDEX_PATTERN.map(index => `-${index}`), ..._constants.EXCLUDE_ELASTIC_CLOUD_INDICES];

// Indices that are excludes from the search result (This patterns can't be excluded from the search)
const POST_EXCLUDE_INDICES = exports.POST_EXCLUDE_INDICES = ['.']; // internal indices