"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.oldestValue = exports.newestValue = exports.collectValues = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const collectValues = ({
  destination,
  source,
  fieldHistoryLength = 10,
  mapping = {
    type: 'keyword'
  },
  allowAPIUpdate = false
}) => ({
  destination: destination !== null && destination !== void 0 ? destination : source,
  source,
  retention: {
    operation: 'collect_values',
    maxLength: fieldHistoryLength
  },
  aggregation: {
    type: 'terms',
    limit: fieldHistoryLength
  },
  mapping,
  allowAPIUpdate
});
exports.collectValues = collectValues;
const newestValue = ({
  destination,
  mapping = {
    type: 'keyword'
  },
  source,
  sort,
  allowAPIUpdate
}) => ({
  destination: destination !== null && destination !== void 0 ? destination : source,
  source,
  retention: {
    operation: 'prefer_newest_value'
  },
  aggregation: {
    type: 'top_value',
    sort: sort !== null && sort !== void 0 ? sort : {
      '@timestamp': 'desc'
    }
  },
  mapping,
  allowAPIUpdate
});
exports.newestValue = newestValue;
const oldestValue = ({
  source,
  destination,
  mapping = {
    type: 'keyword'
  },
  sort
}) => ({
  destination: destination !== null && destination !== void 0 ? destination : source,
  source,
  retention: {
    operation: 'prefer_oldest_value'
  },
  aggregation: {
    type: 'top_value',
    sort: sort !== null && sort !== void 0 ? sort : {
      '@timestamp': 'asc'
    }
  },
  mapping,
  allowAPIUpdate: false // oldest value should never be updated
});
exports.oldestValue = oldestValue;