"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.robustIsPathValid = void 0;
var _is_objectlike_or_array_of_objectlikes = require("./is_objectlike_or_array_of_objectlikes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Returns true if path in SignalSource object is valid
 * Path is valid if each field in hierarchy is object or undefined
 * Path is not valid if ANY of field in hierarchy is not object or undefined
 * The function is robust in that it can handle any mix of dot and nested notation in the document
 * @param key Path (dot-notation) to check for validity
 * @param document Document to search
 * @returns boolean
 */
const robustIsPathValid = (key, document) => {
  const splitKey = key.split('.');
  let tempKey = splitKey[0];
  for (let i = 0; i < splitKey.length; i++) {
    if (i > 0) {
      tempKey += `.${splitKey[i]}`;
    }
    const value = document[tempKey];
    if (value != null) {
      if (!(0, _is_objectlike_or_array_of_objectlikes.isObjectTypeGuard)(value)) {
        return false;
      } else {
        return robustIsPathValid(splitKey.slice(i + 1).join('.'), value);
      }
    }
  }
  return true;
};
exports.robustIsPathValid = robustIsPathValid;